#!/usr/local/bin/perl
# -----------------------------------------------------------------
# bdlibrary.pl
# 
# Author: Mic Bowman 
#
# A library of routines for description maintenance for the Harvest
# HSR.
# -----------------------------------------------------------------

# -----------------------------------------------------------------
# BD_ReadDescriptions -- read a list of descriptions
# -----------------------------------------------------------------
sub BD_ReadDescriptions {
    local(%list);
    local($filename);

    $filename = &HSR_FileName("Descriptions","List");
    
    open(DFILE,"<$filename") ||
	&CGIError("Unable to locate description list");

    while (<DFILE>) {
	chop;
	next if (/^\s*!/);	# Skip comments
	next if (/^\s*$/);	# Skip blanks
	($type, $file, $home) = /^\s*(\S+)\s+(\S+)\s+(\S+)\s*$/;
	$list{$file} = join('&',$type,$home);
    }

    return (%list);
}

# -----------------------------------------------------------------
# BD_AddDescription
# -----------------------------------------------------------------
sub BD_AddDescription {
    local($type,$file,$home) = @_;
    local($filename);

    $filename = &HSR_FileName("Descriptions","List");
    
    open(DFILE,">>$filename") ||
	&CGIError("Unable to locate description list");

    print DFILE "$type $file $home\n";

    close(DFILE);
}

# -----------------------------------------------------------------
# BD_ReadTags -- read the list of tags
# -----------------------------------------------------------------
sub BD_ReadTags {
    local($stype) = @_;
    local(%list);
    local($filename);
    local($name,$mandatory,$manual,$auto,$desc);

    $filename = &HSR_FileName("Tags",$stype);

    open(TFILE,"<$filename") ||
	&CGIError("Unable to open tags file $filename");

    while (<TFILE>) {
	chop;
	next if (/^\s*!/);	# Skip comments
	next if (/^\s*$/);	# Skip blanks
	
	($name,$btype,$mandatory,$manual,$auto,$desc) =
	    /^\s*(\S+)\s+([SPN])\s+([YN])\s+([YN])\s+([YN])\s+(\S.*)$/;

	$list{$name} = join('&',$btype,$mandatory,$manual,$auto,$desc);
    }

    return (%list);
}

# -----------------------------------------------------------------
# BD_ReadTools -- read a list of tools
# -----------------------------------------------------------------
sub BD_ReadTools {
    local(%list);
    local($filename);

    $toolhome = $Config{"Tools.Home"};
    $filename = &HSR_FileName("Tools","List");

    open(TFILE,"<$filename") ||
	&CGIError("Unable to locate tools list");

    while (<TFILE>) {
	chop;
	next if (/^\s*!/);	# Skip comments
	next if (/^\s*$/);	# Skip blanks
	($type, $file, $desc) = /^\s*(\S+)\s+(\S+)\s+(\S.*)$/;
	$list{join('&',$file,$type)} = $desc;
    }

    return (%list);
}

# -----------------------------------------------------------------
# BD_InputBox -- Create a string with a box
# -----------------------------------------------------------------
sub BD_InputBox {
    local($btype,$tag,$val) = @_;
    local($value);
    
    $value = "";
    if ($btype eq "S") {
	$value = "value=\"$val\"" if ($val !~ /^\s*$/);
	$box = "<input type=TEXT name=\"$tag\" size=70 $value>";
    } elsif ($btype eq "P") {
	$box = "<textarea name=\"$tag\" rows=\"5\" cols=\"70\">";
	$box = $box . "$val</textarea>";
    } elsif ($btype eq "N") {
	$value = "value=\"$val\"" if ($val !~ /^\s*$/);
	$box = "<input type=TEXT name=\"$tag\" size=20 $value>";
    }
    return($box);
}

# -----------------------------------------------------------------
1
