#include "global.h"


void CreateMwsrcBody(parent)
Widget parent;
{
int ac=0;
Arg al[10];





mwsrc_tcp_port_text=XmCreateText(parent, "mwsrc_tcp_port_text", al, ac);
XtManageChild(mwsrc_tcp_port_text);

mwsrc_database_name_text= XmCreateText(parent, "mwsrc_database_name_text", al, ac);
XtManageChild(mwsrc_database_name_text);

mwsrc_cost_text = XmCreateText(parent, "mwsrc_cost_text", al, ac);
XtManageChild(mwsrc_cost_text);

mwsrc_cost_unit_text = XmCreateText(parent, "mwsrc_cost_unit_text", al, ac);
XtManageChild(mwsrc_cost_unit_text);

mwsrc_maintainer_text = XmCreateText(parent, "mwsrc_maintainer_text", al, ac);
XtManageChild(mwsrc_maintainer_text);

mwsrc_description_text = XmCreateScrolledText(parent, "mwsrc_description_text", al, ac);
XtManageChild(mwsrc_description_text);


mwsrc_tcp_port_label=XmCreateLabel(parent, "mwsrc_tcp_port_label", al, ac);
XtManageChild(mwsrc_tcp_port_label);

mwsrc_database_name_label= XmCreateLabel(parent, "mwsrc_database_name_label", al, ac);
XtManageChild(mwsrc_database_name_label);

mwsrc_cost_label = XmCreateLabel(parent, "mwsrc_cost_label", al, ac);
XtManageChild(mwsrc_cost_label);

mwsrc_cost_unit_label = XmCreateLabel(parent, "mwsrc_cost_unit_label", al, ac);
XtManageChild(mwsrc_cost_unit_label);

mwsrc_maintainer_label = XmCreateLabel(parent, "mwsrc_maintainer_label", al, ac);
XtManageChild(mwsrc_maintainer_label);

mwsrc_description_label = XmCreateLabel(parent, "mwsrc_description_label", al, ac);
XtManageChild(mwsrc_description_label);

}

void MwsrcDialogCancelCB (w, client_data, call_data) 
Widget		w;
caddr_t		client_data;
caddr_t		call_data;
{

XtUnmanageChild(w);

}


void MwsrcDialogForceCB (w, client_data, call_data) 
Widget		w;
caddr_t		client_data;
caddr_t		call_data;
{

void MwsrcWipe();


	switch ((int)client_data) {

		case DIALOG_CONFIRM_CLOSE:
			MwsrcWipe();
			break;
		case DIALOG_CONFIRM_EXIT:
			exit(0);
			break;
		}


}


void MwsrcDialogAcceptCB (w, client_data, call_data) 
Widget		w;
caddr_t		client_data;
caddr_t		call_data;
{
	char *command;		/* command used in printing */
	char *jumpstr;
	void MwsrcOpenFile(),MwsrcNewFile(),MwsrcWipe(),MwsrcSave();

	switch ((int)client_data)
	{
		case DIALOG_FSELECT:
		        /* open the file and read it into the text widget */
			if (filename != NULL) 
			{
			   XtFree(filename);
			   filename = NULL;
                        }
			{
                           struct stat stbuf;
                           char s[1000];
			   XmFileSelectionBoxCallbackStruct *fcb =
				 (XmFileSelectionBoxCallbackStruct *) call_data;

			   /* get the filename from the file selection box */
			   XmStringGetLtoR(fcb->value, XmSTRING_DEFAULT_CHARSET, &filename);

                           stat(filename,&stbuf);
                           if ((stbuf.st_mode & S_IFDIR) != 0)
                           {
                           }
                           else
			   {
                                XtUnmanageChild(w);
			        if (filename[0]!='\0')
			          MwsrcOpenFile();
                           }
			}
			break;
		case DIALOG_NEW:
			if (filename != NULL) 
			{
			   XtFree(filename);
			   filename = NULL;
                        }
			{
			   XmSelectionBoxCallbackStruct *scb =
				 (XmSelectionBoxCallbackStruct *) call_data;

			   /* get the filename string from the file
			      name prompt box */
			   XmStringGetLtoR(scb->value, XmSTRING_DEFAULT_CHARSET, &filename);
			   /* popdown the file selection box */
		  	   XtUnmanageChild (MwsrcNewDialog);
			   /* open file if it exists,
			      if not set items sensitive*/
                           if (filename!=NULL)
                           if ((filename[0]!='\0') && (strlen(filename)>0) ) {
			      if (savefilename != NULL) XtFree(savefilename);
			      savefilename=(char *)malloc(strlen(filename));
			      strcpy(savefilename,filename);
			      MwsrcNewFile();
                              }

			}
			break;
		case DIALOG_SAVE_AS:
			if (savefilename != NULL) 
			{
			   XtFree(savefilename);
			   savefilename = NULL;
                        }
			{
			   XmSelectionBoxCallbackStruct *scb =
				 (XmSelectionBoxCallbackStruct *) call_data;

			   /* get the filename string from the file
			      name prompt box */
			   XmStringGetLtoR(scb->value, XmSTRING_DEFAULT_CHARSET, &savefilename);
			   /* popdown the file selection box */
		  	   XtUnmanageChild (MwsrcSaveAsDialog);
                           if (savefilename!=NULL)
                           if ((savefilename[0]!='\0') && (strlen(savefilename)>0) ) {
			      MwsrcSave();
			      MwsrcShouldSave=True;
                              }

			}
			break;
		case DIALOG_CONFIRM_CLOSE:
			MwsrcSave();
			MwsrcWipe();
			break;
		case DIALOG_CONFIRM_EXIT:
			MwsrcSave();
			exit(0);
			break;

	}
}




void CreateMwsrcOpenDialog()
{
int ac=0;
Arg al[2];
void MwsrcDialogAcceptCB();
void MwsrcDialogCancelCB();

MwsrcOpenDialog = XmCreateFileSelectionDialog(app_shell,"MwsrcOpenDialog", al, ac);
XtAddCallback (	MwsrcOpenDialog, XmNokCallback,
		MwsrcDialogAcceptCB, DIALOG_FSELECT);
XtAddCallback (	MwsrcOpenDialog, XmNcancelCallback,
		MwsrcDialogCancelCB, DIALOG_FSELECT);

}

void CreateMwsrcNewDialog()
{
int ac=0;
Arg al[2];

MwsrcNewDialog = XmCreatePromptDialog(app_shell,"MwsrcNewDialog", al, ac);
XtAddCallback (	MwsrcNewDialog, XmNokCallback,
		MwsrcDialogAcceptCB, DIALOG_NEW);

}


void CreateMwsrcSaveAsDialog()
{
int ac=0;
Arg al[2];

MwsrcSaveAsDialog = XmCreatePromptDialog(app_shell,"MwsrcSaveAsDialog", al, ac);
XtAddCallback (	MwsrcSaveAsDialog, XmNokCallback,
		MwsrcDialogAcceptCB, DIALOG_SAVE_AS);

}

void CreateMwsrcConfirmCloseDialog()
{
int ac=0;
Arg al[2];

MwsrcConfirmCloseDialog = XmCreateWarningDialog(app_shell,"MwsrcConfirmCloseDialog", al, ac);
XtAddCallback (	MwsrcConfirmCloseDialog, XmNokCallback,
		MwsrcDialogAcceptCB, DIALOG_CONFIRM_CLOSE);
XtAddCallback (	MwsrcConfirmCloseDialog, XmNcancelCallback,
		MwsrcDialogForceCB, DIALOG_CONFIRM_CLOSE);
XtAddCallback (	MwsrcConfirmCloseDialog, XmNhelpCallback,
		MwsrcDialogCancelCB, DIALOG_CONFIRM_CLOSE);

}

void CreateMwsrcConfirmExitDialog()
{
int ac=0;
Arg al[2];

MwsrcConfirmExitDialog = XmCreateWarningDialog(app_shell,"MwsrcConfirmExitDialog", al, ac);
XtAddCallback (	MwsrcConfirmExitDialog, XmNokCallback,
		MwsrcDialogAcceptCB, DIALOG_CONFIRM_EXIT);
XtAddCallback (	MwsrcConfirmExitDialog, XmNcancelCallback,
		MwsrcDialogForceCB, DIALOG_CONFIRM_EXIT);
XtAddCallback (	MwsrcConfirmExitDialog, XmNhelpCallback,
		MwsrcDialogCancelCB, DIALOG_CONFIRM_EXIT);

}

void MwsrcNewFile()
{

   XmTextSetString(mwsrc_ip_name_text,"");
   XmTextSetString(mwsrc_tcp_port_text,"");
   XmTextSetString(mwsrc_database_name_text,"");
   XmTextSetString(mwsrc_cost_text,"");
   XmTextSetString(mwsrc_cost_unit_text,"");
   XmTextSetString(mwsrc_maintainer_text,"");
   XmTextSetString(mwsrc_description_text,"");

   XtSetSensitive(open_button,False);
   XtSetSensitive(new_button,False);
   XtSetSensitive(save_button,True);
   XtSetSensitive(save_as_button,True);
   XtSetSensitive(close_button,True);

MwsrcShouldSave = True;

}

void MwsrcWipe()
{

   XmTextSetString(mwsrc_ip_name_text,"");
   XmTextSetString(mwsrc_tcp_port_text,"");
   XmTextSetString(mwsrc_database_name_text,"");
   XmTextSetString(mwsrc_cost_text,"");
   XmTextSetString(mwsrc_cost_unit_text,"");
   XmTextSetString(mwsrc_maintainer_text,"");
   XmTextSetString(mwsrc_description_text,"");

   XtSetSensitive(open_button,True);
   XtSetSensitive(new_button,True);
   XtSetSensitive(save_button,False);
   XtSetSensitive(save_as_button,False);
   XtSetSensitive(close_button,False);
}


void MwsrcPopupOpenDialog()
{
char *homedir;
char sourcedir[MAXPATHLEN];

homedir = (char *)getenv("HOME");
sprintf(sourcedir,"%s/wais-sources",homedir);
chdir(sourcedir);

if (MwsrcOpenDialog==NULL) {
   CreateMwsrcOpenDialog();
   }

XtManageChild(MwsrcOpenDialog);
}



void MwsrcPopupNewDialog()
{

if ( MwsrcNewDialog == NULL ) {
   CreateMwsrcNewDialog();
   }
XtManageChild( MwsrcNewDialog );
}



void MwsrcSave()
{
int noWaisSources;
char *myHome,myWaisSourcesDir[256];

/* Open the file for writing, make a source structure, and then close it. */

FILE *srcfile;

srcfile = fopen(savefilename,"w");
if (srcfile==NULL) {
   myHome = getenv("HOME");
   sprintf(myWaisSourcesDir,"%s/wais-sources",myHome);
   noWaisSources = access(myWaisSourcesDir,X_OK);
   if (noWaisSources == -1) { /* if there WASN'T a wais-sources dir */
      mkdir(myWaisSourcesDir,0777);
      }
   srcfile = fopen(savefilename,"w");
   }

if (srcfile == NULL) {
   fprintf(stderr,"Could not save source");
   return;
   }

fprintf(srcfile,"(:source\n   :version  3\n   :ip-name \"%s\"",XmTextGetString(mwsrc_ip_name_text));
fprintf(srcfile,"\n   :tcp-port %s\n",XmTextGetString(mwsrc_tcp_port_text));
fprintf(srcfile,"   :database-name \"%s\"\n",XmTextGetString(mwsrc_database_name_text));
fprintf(srcfile,"   :cost %s\n",XmTextGetString(mwsrc_cost_text));
fprintf(srcfile,"   :cost-unit %s\n",XmTextGetString(mwsrc_cost_unit_text));
fprintf(srcfile,"   :maintainer \"%s\"\n",XmTextGetString(mwsrc_maintainer_text));
fprintf(srcfile,"   :description\n\"%s\"",XmTextGetString(mwsrc_description_text));
fprintf(srcfile,"\n)\n");
fclose(srcfile);

MwsrcShouldSave = False;

}


void MwsrcPopupSaveAsDialog()
{
if ( MwsrcSaveAsDialog == NULL ) {
   CreateMwsrcSaveAsDialog();
   }
XtManageChild( MwsrcSaveAsDialog );
}


void MwsrcClose()
{
if (MwsrcShouldSave) {
   if (MwsrcConfirmCloseDialog == NULL) {
      CreateMwsrcConfirmCloseDialog();
      }
   XtManageChild(MwsrcConfirmCloseDialog);
   }
else {
   MwsrcWipe();
   }

}

void MwsrcWrapupAndExit()
{

if (MwsrcShouldSave) {
   if (MwsrcConfirmExitDialog == NULL) {
      CreateMwsrcConfirmExitDialog();
      }
   XtManageChild(MwsrcConfirmExitDialog);
   }
else {
   exit(0);
   }

}



void MwsrcMenuCB(w, client_data, call_data)
Widget          w;
caddr_t         client_data;
caddr_t         call_data;
{

switch ((int)client_data) {
	case MENU_OPEN:
		MwsrcPopupOpenDialog();
		break;
	case MENU_NEW:
		MwsrcPopupNewDialog();
		break;
	case MENU_SAVE:
		MwsrcSave();
		break;
	case MENU_SAVE_AS:
		MwsrcPopupSaveAsDialog();
		break;
	case MENU_CLOSE:
		MwsrcClose();
		break;
	case MENU_EXIT:
		MwsrcWrapupAndExit();
		break;
	}

}

void MwsrcParseAndLoad()
{
char *findit;
char ipnamestr[256],tcpportstr[256],databasestr[256],coststr[256];
char costunitstr[256],descriptionstr[8192],maintainerstr[256];
int  tcpport,idx;
float cost;


ipnamestr[0]='\0';
findit = strstr(sourcebuff,":ip-name ");
if (findit != NULL) {
   findit = findit + 10;
   sscanf(findit,"%s",ipnamestr);
   findit=strstr(ipnamestr,"\"");
   *findit='\0';
   }
XmTextSetString(mwsrc_ip_name_text,ipnamestr);

tcpportstr[0]='\0';
findit = strstr(sourcebuff,":tcp-port ");
if (findit != NULL) {
   findit = findit + 10;
   sscanf(findit,"%d",&tcpport);
   sprintf(tcpportstr,"%d",tcpport);
   }
XmTextSetString(mwsrc_tcp_port_text,tcpportstr);

databasestr[0]='\0';
findit = strstr(sourcebuff,":database-name ");
if (findit != NULL) {
   findit = findit + 16;
   sscanf(findit,"%s",databasestr);
   findit=strstr(databasestr,"\"");
   *findit='\0';
   }
XmTextSetString(mwsrc_database_name_text,databasestr);

coststr[0]='\0';
findit = strstr(sourcebuff,":cost ");
if (findit != NULL) {
   findit = findit + 6;
   sscanf(findit,"%f",&cost);
   sprintf(coststr,"%f",cost);
   }
XmTextSetString(mwsrc_cost_text,coststr);


costunitstr[0]='\0';
findit = strstr(sourcebuff,":cost-unit ");
if (findit != NULL) {
   findit = findit + 10;
   sscanf(findit,"%s",costunitstr);
   }
XmTextSetString(mwsrc_cost_unit_text,costunitstr);


maintainerstr[0]='\0';
findit = strstr(sourcebuff,":maintainer ");
if (findit != NULL) {
   findit = findit + 13;
   sscanf(findit,"%s",maintainerstr);
   findit=strstr(maintainerstr,"\"");
   *findit='\0';
   }
XmTextSetString(mwsrc_maintainer_text,maintainerstr);


descriptionstr[0]='\0';
findit = strstr(sourcebuff,":description ");
if (findit != NULL) {
   while (*findit != '"') findit++; findit++;
   idx=0;
   while (*findit != '"') {
      descriptionstr[idx]= *findit;
      idx++;
      findit++;
      }
   descriptionstr[idx]='\0';
   }
XmTextSetString(mwsrc_description_text,descriptionstr);


}


void MwsrcOpenFile()
{

   struct stat statbuf;		/* Information on a file. */
   int file_length;		/* Length of file. 	  */
   FILE *fp = NULL;		/* Pointer to open file   */
   Arg al[10];				/* arg list		    */
   int idx;
   int cin;


if (sourcebuff != NULL) {
   XtFree(sourcebuff);
   }



   if (stat(filename, &statbuf) == 0)
	 file_length = statbuf.st_size;
   else
	 file_length = 1000000; /* arbitrary file length */

   /* read the file string */
   sourcebuff = (char *) XtMalloc(((unsigned)file_length)+2);
   *sourcebuff = '\0';

   fp=fopen(filename,"r");

   idx=0;   
   while ((cin=fgetc(fp))!=EOF) {
      sourcebuff[idx]=cin;
      idx++;
      }
   sourcebuff[idx]='\0';


   if (fclose(fp) != NULL) 
     fprintf(stderr, "Warning: unable to close file.\n");


   MwsrcParseAndLoad();

   XtSetSensitive(open_button,False);
   XtSetSensitive(new_button,False);
   XtSetSensitive(save_button,True);
   XtSetSensitive(save_as_button,True);
   XtSetSensitive(close_button,True);

MwsrcShouldSave = True;

}

