
use strict;
use warnings;

use 5.010001;

use ExtUtils::MakeMaker 6.30;



my %WriteMakefileArgs = (
  "ABSTRACT" => "SHARYANTO's temporary namespace for various routines",
  "AUTHOR" => "Steven Haryanto <stevenharyanto\@gmail.com>",
  "BUILD_REQUIRES" => {},
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => "6.30"
  },
  "DISTNAME" => "SHARYANTO-Utils",
  "EXE_FILES" => [],
  "LICENSE" => "perl",
  "NAME" => "SHARYANTO::Utils",
  "PREREQ_PM" => {
    "Data::Clone" => 0,
    "File::Slurp" => 0,
    "File::Which" => 0,
    "HTML::Parser" => 0,
    "Parse::Netstat" => 0,
    "Rinci" => "v1.1.0",
    "Template::Tiny" => 0,
    "URI::URL" => 0,
    "experimental" => 0
  },
  "TEST_REQUIRES" => {
    "File::Spec" => 0,
    "IO::Handle" => 0,
    "IPC::Open3" => 0,
    "Test::Exception" => 0,
    "Test::More" => "0.98"
  },
  "VERSION" => "0.64",
  "test" => {
    "TESTS" => "t/*.t"
  }
);


my %FallbackPrereqs = (
  "Data::Clone" => 0,
  "File::Slurp" => 0,
  "File::Spec" => 0,
  "File::Which" => 0,
  "HTML::Parser" => 0,
  "IO::Handle" => 0,
  "IPC::Open3" => 0,
  "Parse::Netstat" => 0,
  "Rinci" => "v1.1.0",
  "Template::Tiny" => 0,
  "Test::Exception" => 0,
  "Test::More" => "0.98",
  "URI::URL" => 0,
  "experimental" => 0
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



