#!/usr/bin/perl -w

require 5.010000;

$runtests=shift(@ARGV);
if ( -f "t/test.pl" ) {
  require "t/test.pl";
  $dir="./lib";
  $tdir="t";
} elsif ( -f "test.pl" ) {
  require "test.pl";
  $dir="../lib";
  $tdir=".";
} else {
  die "ERROR: cannot find test.pl\n";
}

unshift(@INC,$dir);
use Date::Manip::TZ;

sub test {
  (@test)=@_;
  @per = $obj->periods(@test);
  @ret = ();
  foreach my $per (@per) {
     push(@ret,@$per);
  }
  return @ret;
}

$obj = new Date::Manip::TZ;
$obj->config("forcedate","now,America/New_York");

$tests="
America/New_York
1
~
   [] 1,1,2,0,0,0
   [] 1,1,1,19,3,58
   -04:56:02
   [] -4,-56,-2
   LMT
   0
   [] 1883,11,18,16,59,59
   [] 1883,11,18,12,3,57
   0001010200:00:00
   0001010119:03:58
   1883111816:59:59
   1883111812:03:57

America/New_York
1800
~

America/New_York
1883
~
   [] 1883,11,18,17,0,0
   [] 1883,11,18,12,0,0
   -05:00:00
   [] -5,0,0
   EST
   0
   [] 1918,3,31,6,59,59
   [] 1918,3,31,1,59,59
   1883111817:00:00
   1883111812:00:00
   1918033106:59:59
   1918033101:59:59

America/New_York
1926
~
   [] 1926,4,25,7,0,0
   [] 1926,4,25,3,0,0
   -04:00:00
   [] -4,0,0
   EDT
   1
   [] 1926,9,26,5,59,59
   [] 1926,9,26,1,59,59
   1926042507:00:00
   1926042503:00:00
   1926092605:59:59
   1926092601:59:59
   [] 1926,9,26,6,0,0
   [] 1926,9,26,1,0,0
   -05:00:00
   [] -5,0,0
   EST
   0
   [] 1927,4,24,6,59,59
   [] 1927,4,24,1,59,59
   1926092606:00:00
   1926092601:00:00
   1927042406:59:59
   1927042401:59:59

America/New_York
2037
~
   [] 2037,3,8,7,0,0
   [] 2037,3,8,3,0,0
   -04:00:00
   [] -4,0,0
   EDT
   1
   [] 2037,11,1,5,59,59
   [] 2037,11,1,1,59,59
   2037030807:00:00
   2037030803:00:00
   2037110105:59:59
   2037110101:59:59
   [] 2037,11,1,6,0,0
   [] 2037,11,1,1,0,0
   -05:00:00
   [] -5,0,0
   EST
   0
   [] 2038,3,14,6,59,59
   [] 2038,3,14,1,59,59
   2037110106:00:00
   2037110101:00:00
   2038031406:59:59
   2038031401:59:59

America/New_York
2100
~
   [] 2100,3,14,7,0,0
   [] 2100,3,14,3,0,0
   -04:00:00
   [] -4,0,0
   EDT
   1
   [] 2100,11,7,5,59,59
   [] 2100,11,7,1,59,59
   2100031407:00:00
   2100031403:00:00
   2100110705:59:59
   2100110701:59:59
   [] 2100,11,7,6,0,0
   [] 2100,11,7,1,0,0
   -05:00:00
   [] -5,0,0
   EST
   0
   [] 2101,3,13,6,59,59
   [] 2101,3,13,1,59,59
   2100110706:00:00
   2100110701:00:00
   2101031306:59:59
   2101031301:59:59

Africa/Cairo
2037
~
   [] 2037,4,23,22,0,0
   [] 2037,4,24,1,0,0
   +03:00:00
   [] 3,0,0
   EEST
   1
   [] 2037,9,24,20,59,59
   [] 2037,9,24,23,59,59
   2037042322:00:00
   2037042401:00:00
   2037092420:59:59
   2037092423:59:59
   [] 2037,9,24,21,0,0
   [] 2037,9,24,23,0,0
   +02:00:00
   [] 2,0,0
   EET
   0
   [] 2038,4,29,21,59,59
   [] 2038,4,29,23,59,59
   2037092421:00:00
   2037092423:00:00
   2038042921:59:59
   2038042923:59:59

Asia/Damascus
2038
~
   [] 2038,3,25,22,0,0
   [] 2038,3,26,1,0,0
   +03:00:00
   [] 3,0,0
   EEST
   1
   [] 2038,10,28,20,59,59
   [] 2038,10,28,23,59,59
   2038032522:00:00
   2038032601:00:00
   2038102820:59:59
   2038102823:59:59
   [] 2038,10,28,21,0,0
   [] 2038,10,28,23,0,0
   +02:00:00
   [] 2,0,0
   EET
   0
   [] 2039,3,24,21,59,59
   [] 2039,3,24,23,59,59
   2038102821:00:00
   2038102823:00:00
   2039032421:59:59
   2039032423:59:59

Asia/Damascus
2039
~
   [] 2039,3,24,22,0,0
   [] 2039,3,25,1,0,0
   +03:00:00
   [] 3,0,0
   EEST
   1
   [] 2039,10,27,20,59,59
   [] 2039,10,27,23,59,59
   2039032422:00:00
   2039032501:00:00
   2039102720:59:59
   2039102723:59:59
   [] 2039,10,27,21,0,0
   [] 2039,10,27,23,0,0
   +02:00:00
   [] 2,0,0
   EET
   0
   [] 2040,3,29,21,59,59
   [] 2040,3,29,23,59,59
   2039102721:00:00
   2039102723:00:00
   2040032921:59:59
   2040032923:59:59

America/New_York
_undef_
1900
~
   [] 1,1,2,0,0,0
   [] 1,1,1,19,3,58
   -04:56:02
   [] -4,-56,-2
   LMT
   0
   [] 1883,11,18,16,59,59
   [] 1883,11,18,12,3,57
   0001010200:00:00
   0001010119:03:58
   1883111816:59:59
   1883111812:03:57
   [] 1883,11,18,17,0,0
   [] 1883,11,18,12,0,0
   -05:00:00
   [] -5,0,0
   EST
   0
   [] 1918,3,31,6,59,59
   [] 1918,3,31,1,59,59
   1883111817:00:00
   1883111812:00:00
   1918033106:59:59
   1918033101:59:59

";

print "periods...\n";
test_Func(\&test,$tests,$runtests);

1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 3
# cperl-continued-statement-offset: 2
# cperl-continued-brace-offset: 0
# cperl-brace-offset: 0
# cperl-brace-imaginary-offset: 0
# cperl-label-offset: -2
# End:

