package Sah::SchemaR::cryptoexchange::account;

our $DATE = '2020-03-08'; # DATE
our $VERSION = '0.009'; # VERSION

our $rschema = ["str",[{description=>"\nThe format of this data is \"<cryptoexchange>/<account>\" where \"<cryptoexchange>\"\nis the name of cryptoexchange (can be code, name or safename, but will be\nnormalized to its safename) and <account> is account nickname in the\ncryptoexchange and must match /\\A[A-Za-z0-9_-]+\\z/. The \"/<account>\" part is\noptional and will be assumed to be \"/default\" if not specified.\n\n",examples=>[{summary=>"Invalid account syntax",valid=>0,value=>"indodax/a b"},{summary=>"Account too long",valid=>0,value=>"indodax/aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"},{summary=>"Unknown cryptoexchange",valid=>0,value=>"foo/acc1"},{summary=>"Valid",valid=>1,validated_value=>"indodax/default",value=>"indodax"}],summary=>"Account at a cryptocurrency exchange","x.completion"=>"cryptoexchange_account","x.perl.coerce_rules"=>["From_str::normalize_cryptoexchange_account"]}],["str"]];

1;
# ABSTRACT: Account at a cryptocurrency exchange

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::SchemaR::cryptoexchange::account - Account at a cryptocurrency exchange

=head1 VERSION

This document describes version 0.009 of Sah::SchemaR::cryptoexchange::account (from Perl distribution Sah-Schemas-App-cryp), released on 2020-03-08.

=head1 DESCRIPTION

This module is automatically generated by Dist::Zilla::Plugin::Sah::Schemas during distribution build.

A Sah::SchemaR::* module is useful if a client wants to quickly lookup the base type of a schema without having to do any extra resolving. With Sah::Schema::*, one might need to do several lookups if a schema is based on another schema, and so on. Compare for example L<Sah::Schema::poseven> vs L<Sah::SchemaR::poseven>, where in Sah::SchemaR::poseven one can immediately get that the base type is C<int>. Currently L<Perinci::Sub::Complete> uses Sah::SchemaR::* instead of Sah::Schema::* for reduced startup overhead when doing tab completion.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-Schemas-App-cryp>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-Schemas-App-cryp>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-Schemas-App-cryp>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020, 2019, 2018 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
