package Chart::Plotly::Trace::Contourcarpet::Colorbar::Title;
use Moose;
use MooseX::ExtraArgs;
use Moose::Util::TypeConstraints qw(enum union);
if ( !defined Moose::Util::TypeConstraints::find_type_constraint('PDL') ) {
    Moose::Util::TypeConstraints::type('PDL');
}

use Chart::Plotly::Trace::Contourcarpet::Colorbar::Title::Font;

our $VERSION = '0.022';    # VERSION

# ABSTRACT: This attribute is one of the possible options for the trace contourcarpet.

sub TO_JSON {
    my $self       = shift;
    my $extra_args = $self->extra_args // {};
    my $meta       = $self->meta;
    my %hash       = %$self;
    for my $name ( sort keys %hash ) {
        my $attr = $meta->get_attribute($name);
        if ( defined $attr ) {
            my $value = $hash{$name};
            my $type  = $attr->type_constraint;
            if ( $type && $type->equals('Bool') ) {
                $hash{$name} = $value ? \1 : \0;
            }
        }
    }
    %hash = ( %hash, %$extra_args );
    delete $hash{'extra_args'};
    if ( $self->can('type') && ( !defined $hash{'type'} ) ) {
        $hash{type} = $self->type();
    }
    return \%hash;
}

has font => ( is  => "rw",
              isa => "Maybe[HashRef]|Chart::Plotly::Trace::Contourcarpet::Colorbar::Title::Font", );

has side => (
    is  => "rw",
    isa => enum( [ "right", "top", "bottom" ] ),
    documentation =>
      "Determines the location of color bar's title with respect to the color bar. Note that the title's location used to be set by the now deprecated `titleside` attribute.",
);

has text => (
    is  => "rw",
    isa => "Str",
    documentation =>
      "Sets the title of the color bar. Note that before the existence of `title.text`, the title's contents used to be defined as the `title` attribute itself. This behavior has been deprecated.",
);

__PACKAGE__->meta->make_immutable();
1;

__END__

=pod

=encoding utf-8

=head1 NAME

Chart::Plotly::Trace::Contourcarpet::Colorbar::Title - This attribute is one of the possible options for the trace contourcarpet.

=head1 VERSION

version 0.022

=head1 SYNOPSIS

 use Chart::Plotly qw(show_plot);
 use Chart::Plotly::Trace::Carpet;
 use Chart::Plotly::Trace::Contourcarpet;
 # Example data from: https://plot.ly/javascript/carpet-contour/#add-contours
 my $contourcarpet = Chart::Plotly::Trace::Contourcarpet->new(
     a           => [ 0, 1, 2, 3, 0, 1, 2, 3, 0, 1, 2, 3 ],
     b           => [ 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6 ],
     z           => [ 1, 1.96, 2.56, 3.0625, 4, 5.0625, 1, 7.5625, 9, 12.25, 15.21, 14.0625 ],
     autocontour => 0,
     contours    => {
         start => 1,
         end   => 14,
         size  => 1
     },
     line        => {
         width     => 2,
         smoothing => 0
     },
     colorbar    => {
         len => 0.4,
         y   => 0.25
     }
 );
 
 my $carpet = Chart::Plotly::Trace::Carpet->new(
     a     => [ 0, 1, 2, 3, 0, 1, 2, 3, 0, 1, 2, 3 ],
     b     => [ 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6 ],
     x     => [ 2, 3, 4, 5, 2.2, 3.1, 4.1, 5.1, 1.5, 2.5, 3.5, 4.5 ],
     y     => [ 1, 1.4, 1.6, 1.75, 2, 2.5, 2.7, 2.75, 3, 3.5, 3.7, 3.75 ],
     aaxis => {
         tickprefix     => "a = ",
         smoothing      => 0,
         minorgridcount => 9,
         type           => 'linear'
     },
     baxis => {
         tickprefix     => "b = ",
         smoothing      => 0,
         minorgridcount => 9,
         type           => 'linear'
     }
 );
 
 show_plot([ $contourcarpet, $carpet ]);

=head1 DESCRIPTION

This attribute is part of the possible options for the trace contourcarpet.

This file has been autogenerated from the official plotly.js source.

If you like Plotly, please support them: L<https://plot.ly/> 
Open source announcement: L<https://plot.ly/javascript/open-source-announcement/>

Full reference: L<https://plot.ly/javascript/reference/#contourcarpet>

=head1 DISCLAIMER

This is an unofficial Plotly Perl module. Currently I'm not affiliated in any way with Plotly. 
But I think plotly.js is a great library and I want to use it with perl.

=head1 METHODS

=head2 TO_JSON

Serialize the trace to JSON. This method should be called only by L<JSON> serializer.

=head1 ATTRIBUTES

=over

=item * font

=item * side

Determines the location of color bar's title with respect to the color bar. Note that the title's location used to be set by the now deprecated `titleside` attribute.

=item * text

Sets the title of the color bar. Note that before the existence of `title.text`, the title's contents used to be defined as the `title` attribute itself. This behavior has been deprecated.

=back

=head1 AUTHOR

Pablo Rodríguez González <pablo.rodriguez.gonzalez@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018 by Pablo Rodríguez González.

This is free software, licensed under:

  The MIT (X11) License

=cut
