/** @file spec.h
 * Thumbnail specification handling
 * @author Marko Mkel <msmakela@nic.funet.fi>
 */

/* Copyright  2003 Marko Mkel.

   This file is part of PHOTOMOLO, a program for generating
   thumbnail images and HTML files for browsing digital photographs.

   PHOTOMOLO is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   PHOTOMOLO is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   The GNU General Public License is often shipped with GNU software, and
   is generally kept in a file called COPYING or LICENSE.  If you do not
   have a copy of the license, write to the Free Software Foundation,
   59 Temple Place, Suite 330, Boston, MA 02111 USA. */

/** thumbnail specification */
struct thumb_spec
{
  /** link to next entry */
  struct thumb_spec* next;
  /** shrink factor for thumbnails (0=unspecified, or 1, 2, 4 or 8) */
  unsigned shrink;
  /** desired or maximum image width (0=unspecified) */
  unsigned max_width;
  /** desired or maximum image height (0=unspecified) */
  unsigned max_height;
  /** thumbnail directory name */
  char thumbdir[1];
};

/** parse a thumbnail specification
 * @param spec	the specification string
 * @return	the corresponding specification, or NULL on parse error
 */
struct thumb_spec*
parse_spec (const char* spec);

/** convert a thumbnail specification to a string
 * @param spec	the specification string
 * @return	text string describing the specification
 */
const char*
specstr (const struct thumb_spec* spec);
