#ifndef lint
static char *RCSid = "$Header: /u/dhay/stan/kent/update/RCS/main.c,v 1.1 91/03/19 23:39:18 dhay Exp Locker: dhay $";
#endif

/*
 * idle.c
 *
 * Stamps out idle players.  Runs at low priority.
 *
 * Dave Pare, 1994
 */

#include "misc.h"
#include "player.h"
#include "io.h"
#include "lwp.h"
#include "proto.h"

/*ARGSUSED*/
void
player_kill_idle(argc, argv)
	int	argc;
	s_char	**argv;
{
	extern int max_idle;
	struct	player *p;
	long	now;

	time(&now);
	while (1) {
		lwpSleepUntil(now + 60);
		time(&now);
		/*if (update_pending)*/
			/*continue;*/
		for (p = player_next(0); p != 0; p = player_next(p)) {
			if (p->state == PS_SHUTDOWN) {
				/* no more mr. nice guy */
				p->state = PS_KILL;
				p->aborted++;
				lwpTerminate(p->proc);
				p = player_delete(p);
				continue;
			}
			if (p->curup + max_idle * 60 < now) {
				p->state = PS_SHUTDOWN;
				p->aborted++;
				io_puts(p->iop, "%x idle connection terminated\n", C_DATA);
				lwpWakeupFd(p->proc);
			}
		}
	}
	/*NOTREACHED*/
}
