#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/subs/pr.c,v 2.1 1995/02/13 20:07:29 empire Exp $";
#endif

/*
 * pr.c
 *
 * The pr routine historically arranged for nonbuffered i/o
 * because stdio didn't used to automatically flush stdout before
 * it read something from stdin.  Now pr() prepends an "output id"
 * in front of each line of text, informing the user interface
 * what sort of item it is seeing; prompt, noecho prompt,
 * more input data, etc.
 *
 * Dave Pare, 1986, 1989
 */

#include <ctype.h>
#include <varargs.h>
#include "proto.h"
#include "misc.h"
#include "player.h"
#include "nat.h"
#include "io.h"
#include "file.h"
#include "news.h"
#include "tel.h"

/*VARARGS*/
pr(va_alist)
	va_dcl
{
	s_char	buf[4096];
	s_char	*format;
	va_list	ap;

	va_start(ap);
	format = va_arg(ap, s_char *);
	(void) vsprintf(buf, format, ap);
	va_end(ap);
	_pr(C_DATA, buf);
}

prnf(buf)
	s_char *buf;
{
	_pr(C_DATA, buf);
}

/*VARARGS*/
pr_id(va_alist)
	va_dcl
{
	s_char	buf[4096];
	s_char	*format;
	va_list	ap;
	int	id;

	va_start(ap);
	id = va_arg(ap, int);
	format = va_arg(ap, s_char *);
	(void) vsprintf(buf, format, ap);
	va_end(ap);
	_pr(id, buf);
}

static
_pr(id, buf)
	int	id;
	s_char	*buf;
{
	register s_char *p;
	register s_char *bp;
	register int len;

	bp = buf;
	while (*bp != '\0') {
		if (player->bol) {
			outid(id);
			player->bol = 0;
		}
		p = index(bp, '\n');
		if (p != 0) {
			len = (p - bp) + 1;
			io_write(player->iop, bp, len);
			bp += len;
			player->bol++;
		} else {
			len = io_puts(player->iop, bp);
			bp += len;
		}
	}
}

/*
 * highlighted characters have hex 80 or'ed in
 * with them to designate their highlightedness
 */
pr_hilite(buf)
	s_char *buf;
{
	register s_char *bp;
	register s_char c;
	s_char	*p;

	p = malloc(strlen(buf) + 1);
	strcpy(p, buf);
	for (bp=p; c = *bp; bp++)
		if (isprint(c))
			*bp |= 0x80;
	pr(p);
	free(p);
}

/*
 * output hex code + space
 */
outid(n)
	int	n;
{
	s_char	c;
	s_char	buf[3];

	if (n > 16) {
		logerror("outid: %d not valid code\n", n);
		return;
	}
	if (n >= 10)
		c = 'a' - 10 + n;
	else
		c = '0' + n;
	buf[0] = c;
	buf[1] = ' ';
	buf[2] = '\0';
	io_puts(player->iop, buf);
}

prredir(redir)
	s_char	*redir;
{
	if (*redir == '>')
		outid(C_REDIR);
	else
		outid(C_PIPE);
	io_puts(player->iop, redir);
	io_puts(player->iop, "\n");
}

prexec(file)
	s_char	*file;
{
	outid(C_EXECUTE);
	io_puts(player->iop, file);
	io_puts(player->iop, "\n");
}

/*
 * informs user interface that it should immediately
 * flush it's stdout after receiving this line.  This
 * is probably a prompt.
 */
prflush(buf)
	s_char	*buf;
{
	if (!player->bol) {
		io_puts(player->iop, "\n");
		player->bol = 1;
	}
	_pr(C_FLUSH, buf);
	io_write(player->iop, "\n", 1);
	player->bol = 1;
}

prprompt(min, btu)
	int	min;
	int	btu;
{
	s_char	buf[32];

	outid(C_PROMPT);
	sprintf(buf, "%d %d\n", min, btu);
	io_write(player->iop, buf, strlen(buf));
}

showvers(vers)
	int	vers;
{
	s_char	buf[10];

	(void) outid(C_INIT);
	sprintf(buf, "%d\n", vers);
	io_puts(player->iop, buf);
}

int
prmptrd(prompt, str, size)
	s_char	*prompt;
	s_char	*str;
	int	size;
{
	int	r;

	prflush(prompt);
	if ((r = recvclient(str, size)) < 0)
		return r;
	if (*str == 0)
		return 1;
	return strlen(str);
}

prdate()
{
	extern	s_char *ctime();
	long	now;

	(void) time(&now);
	pr(ctime(&now));
}

/*
 * print x,y formatting as country
 */
prxy(format, x, y, country)
	s_char	*format;
	coord	x;
	coord	y;
	natid	country;
{
	s_char	buf[255];
	struct	natstr *np;

	np = getnatp(country);
	sprintf(buf, format, xrel(np, x), yrel(np, y));
	pr(buf);
}

/*VARARGS*/
PR(va_alist)
        va_dcl
{
        /* XXX should really do this on a per-nation basis */
        static s_char longline[MAXNOC][512];
        int     newline;
        va_list ap;
        natid   cn;
        s_char  *format;
        s_char  buf[1024];

        va_start(ap);
        cn = va_arg(ap, natid);
        format = va_arg(ap, s_char *);
        (void) vsprintf(buf, format, ap);
        va_end(ap);
        newline = strrchr(buf, '\n') ? 1 : 0;
        strcat(longline[cn], buf);
        if (newline){
                if (cn == player->cnum && !player->ismission)
                        _pr(C_DATA, longline[cn]);
                else
			typed_wu(0, cn, longline[cn], TEL_BULLETIN);
                longline[cn][0] = '\0';
        }
}

PRdate(cn)
        natid   cn;
{
        extern  s_char *ctime();
        long    now;

        (void) time(&now);
        PR(cn, ctime(&now));
}


