static char *RCSid = "$Header: recvclient.c,v 1.7 90/04/13 12:24:30 mr-frog Exp $";

/*
 * sendclient.c
 *
 * send and recieve commands
 *
 * Dave Pare, 1986
 */

#include <stdio.h>
#include "misc.h"
#include "bit.h"
#include "io.h"
#include "player.h"
#include "lwp.h"

#include <errno.h>

int
recvclient(cmd, size)
	s_char	*cmd;
	int	size;
{
	extern	int errno;
	int	count;

	if (player->aborted)
		return -2; 
	count = io_gets(player->iop, cmd, size);
	while (!player->aborted && count < 0) {
		if (io_output(player->iop) > 0)
			io_input(player->iop, IO_NOWAIT);
		else
			io_input(player->iop, IO_WAIT);
		if (io_error(player->iop))
			player->aborted++;
		else if (io_eof(player->iop))
			return -1;
		else
			count = io_gets(player->iop, cmd, size);
	}
	if (count > 0) {
		if (strcmp(cmd, "ctld") == 0)
			return -1;
		if (strcmp(cmd, "aborted") == 0)
			player->aborted = 1;
	}
	if (player->aborted)
		return -2;
	return count;
}
