#ifndef lint
static char *RCSid = "$Header: player.c,v 1.3 90/04/13 12:27:37 mr-frog Exp $";
#endif

/*
 * player.c
 *
 * Keep track of people logged in to the game
 *
 * Dave Pare, 1994
 */

#include "misc.h"
#include "bit.h"
#include "proto.h"
#include "player.h"
#include "file.h"
#include "io_mask.h"
#include "lwp.h"
#include "io.h"

#include <sys/socket.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <netdb.h>
#include <netinet/in.h>
#include <signal.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <fcntl.h>

void	player_login();

struct	qelem Players;

player_init()
{
	initque(&Players);
}

struct player *
player_new(s, sin)
	int	s;
	struct	sockaddr_in *sin;
{
	extern char *inet_ntoa();
	struct	player *lp;

	lp = (struct player *) calloc(1, sizeof(*lp));
	if (sin != 0) {
		/* update uses dummy player */
		insque(&lp->queue, &Players);
		strcpy(lp->remhost, inet_ntoa(sin->sin_addr));
		lp->cnum = 255;
		lp->bol = 1;
		lp->iop = io_open(s, IO_READ|IO_WRITE|IO_NBLOCK,
			IO_BUFSIZE, 0, 0);
	}
	return lp;
}

struct player *
player_delete(lp)
	struct	player *lp;
{
	struct	player *back;

	back = (struct player *) lp->queue.q_back;
	if (back)
		remque(&lp->queue);
	if (lp->iop) {
		/* it's a real player */
		io_close(lp->iop);
		lp->iop = 0;
	}
	free((s_char *)lp);
	/* XXX may need to free bigmap here */
	return back;
}

struct player *
player_next(lp)
	struct	player *lp;
{
	if (lp == 0)
		lp = (struct player *)Players.q_forw;
	else
		lp = (struct player *)lp->queue.q_forw;
	if (&lp->queue == &Players)
		return 0;
	return lp;
}

struct player *
player_find_other(us, cnum)
	struct	player *us;
	register natid cnum;
{
	register struct qelem *qp;
	register struct player *lp;

	for (qp = Players.q_forw; qp != &Players; qp = qp->q_forw) {
		lp = (struct player *)qp;
		if (lp == us)
			continue;
		if (lp->cnum == cnum)
			return lp;
	}
	return 0;
}

int
player_wakeup(cnum)
	natid	cnum;
{
	register struct qelem *qp;
	register struct player *lp;

	for (qp = Players.q_forw; qp != &Players; qp = qp->q_forw) {
		lp = (struct player *)qp;
		if (lp->cnum == cnum && lp->waiting)
			lwpWakeupFd(lp->proc);
	}
	return 0;
}

/*ARGSUSED*/
void
player_accept(argc, argv)
	int	argc;
	char	**argv;
{
	extern	s_char loginport[];
	extern	int errno;
	struct	sockaddr_in sin;
	struct	servent *sp;
	int	s;
	short	port;
	int	val;
	int	maxfd;
	struct	player *np;
	int	len;
	int	ns;
	int	set;
	int	stacksize;

	player_init();
	sp = getservbyname("empire", "tcp");
	if (sp == 0)
		port = htons(atoi(loginport));
	else
		port = sp->s_port;
	sin.sin_addr.s_addr = INADDR_ANY;
	sin.sin_port = port;
	sin.sin_family = AF_INET;
	if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
		logerror("inet socket create");
		exit(1);
	}
	val = 1;
	if (setsockopt(s, SOL_SOCKET, SO_REUSEADDR, &val, sizeof(val)) < 0) {
		logerror("inet socket setsockopt SO_REUSEADDR");
		exit(1);
	}
	if (bind(s, (struct sockaddr *) &sin, sizeof(sin)) < 0) {
		logerror("inet socket bind");
		exit(1);
	}
	if (listen(s, SOMAXCONN) < 0) {
		logerror("inet socket listen");
		exit(1);
	}
	maxfd = getdtablesize() - 1;
	while (1) {
		lwpSleepFd(s, LWP_FD_READ);
		len = sizeof(sin);
		ns = accept(s, (struct sockaddr *) &sin, &len);
		if (ns < 0) {
			logerror("new socket accept");
			continue;
		}
		(void) setsockopt(ns, SOL_SOCKET, SO_KEEPALIVE,
			&set, sizeof(set));
		if (ns >= maxfd) {
			logerror("new fd %d, max %d, no fd's left for new user",
				ns, maxfd);
			close(ns);
			continue;
		}
		np = player_new(ns, &sin);
		/* XXX may not be big enough */
		stacksize = 65536 + WORLD_X*WORLD_Y/2;
		lwpCreate(PP_PLAYER, player_login, stacksize, 0, 0, np);
	}
}
