#ifndef lint
static char *RCSid = "$Header: /users/empire/EMP/empmain/gen/RCS/mapdist.c,v 1.1 89/05/17 20:54:11 mr-frog Exp $";
#endif

/*
 * mapdist.c
 *
 * mapdist returns (integer) distance between two sectors.
 * mapdsq returns the square of the distance -- more efficient.
 *
 * from PSL Empire, 1985
 */

#include "misc.h"

int
deltax(x1, x2)
	int	x1;
	int	x2;
{
	int	dx;

	dx = abs(x1 - x2);
	if (dx > WORLD_X/2)
		dx = WORLD_X - dx;
	return dx; 
}

int
deltay(y1, y2)
	int	y1;
	int	y2;
{
	int	dy;

	dy = abs(y1 - y2);
	if (dy > WORLD_Y/2)
		dy = WORLD_Y - dy;
	return dy; 
}

int
mapdist(x1, y1, x2, y2)
	int     x1;
	int     y1;
	int     x2;
	int     y2;
{
	int	dx, dy;

	dx = deltax(x1, x2);
	dy = deltay(y1, y2);
	if (dx > dy)
		return (dx - dy) / 2 + dy;
	return dy;
}

int
mapdsq(x1, y1, x2, y2)
	int     x1;
	int     y1;
	int     x2;
	int     y2;
{
	int	sq;

	sq = mapdist(x1, y1, x2, y2);
	return sq * sq;
}
