#ifndef lint
static char *RCSid = "$Header: /users/empire/EMP/empmain/SUBS/RCS/mtch.c,v 1.1 89/05/17 20:51:59 mr-frog Exp $";
#endif

/*
 * mtch.c
 *
 * Matching operations on structures and commands.
 *
 * XXX These routines gamble that structures are all longword-aligned.
 * If this is not true, they will BREAK!
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "match.h"

/*
 * find a matching string from a member string pointer
 * in a structure "str".  Pointer is incremented by
 * the (passed) size of the structure.
 */
int
stmtch(obj, base, off, size)
	register s_char *obj;
	s_char	*base;
	int	off;
	int     size;
{
	register s_char *str;
	register int stat2;
	register int i;
	register int n;

	stat2 = M_NOTFOUND;
	str = base + off;
	for (i=0; *(s_char **)str; i++, str += size) {
		if ((n = mineq(obj, *(s_char **)str)) == ME_MISMATCH)
			continue;
		if (n == ME_EXACT)
			return i;
		if (stat2 != M_NOTFOUND)
			return M_NOTUNIQUE;
		stat2 = i;
	}
	return stat2;
}

/*
 * do partial match comparison.
 */
int
mineq(a, b)
	register s_char *a;
	register s_char *b;
{
	do {
		if (*a++ != *b++)
			return ME_MISMATCH;
	} while (*b != ' ' && *a != 0);
	if (*a == 0 && (*b == ' ' || *b == 0))
		return ME_EXACT;
	return ME_PARTIAL;
}
