#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/player/commands/RCS/upgr.c,v 1.7 89/09/17 17:36:39 mr-frog Exp $";
#endif /* not lint */

/*
 * upgr.c
 *
 * upgrade tech of ships.
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "player.h"
#include "xy.h"
#include "var.h"
#include "ship.h"
#include "sect.h"
#include "nat.h"
#include "nsc.h"
#include "file.h"

upgr()
{
	struct	sctstr sect;
	struct	natstr *natp;
	struct	nstr_item ni;
	struct	shpstr ship;
	struct	mchrstr *mp;
	int	n;
	int	tlev;
	int	w_p_eff;
	int	points;
	int	rel;

	if (!snxtitem(&ni,EF_SHIP, player->argp[1]))
		return RET_SYN;
        ni.flags &= ~(EFF_OWNER);
	natp = getnatp(player->cnum);
	tlev = (int) natp->nat_level[NAT_TLEV];
	n = 0;
	while (nxtitem(&ni, (s_char *) &ship)) {
		getsect(ship.shp_x, ship.shp_y, &sect);
		if (sect.sct_own != player->cnum)
			continue;
		rel=getrel(getnatp(ship.shp_own),sect.sct_own);
		if ((rel != ALLIED) && (sect.sct_own != ship.shp_own)){
			pr("You are not an ally of the player->owner of ship %d!\n",
				ship.shp_own);
			continue;
		}
		if (!player->owner || sect.sct_type != SCT_HARBR || sect.sct_effic < 60)
			continue;
		n++;
		mp = &mchr[ship.shp_type];
		w_p_eff = ((mp->m_lcm / 2) + mp->m_hcm);
		points = sect.sct_avail * 100 / w_p_eff;
		if (points < 20) {
		    pr("Not enough available work in %s to upgrade a %s\n",
				xyas(sect.sct_x, sect.sct_y, player->cnum),
				mp->m_name);
			pr(" (%d available work required)\n",
				1 + (w_p_eff * 20)/100);
			continue;
		}
		if (ship.shp_effic < 60) {
#ifdef	SHIPNAMES
			pr("%s %s(#%d) is too damaged to upgrade!\n",
				mp->m_name, ship.shp_name, ship.shp_uid);
#else
			pr("%s #%d is too damaged to upgrade!\n",
				mp->m_name, ship.shp_uid);
#endif	SHIPNAMES
			continue;
		}
		if (ship.shp_tech >= tlev) {
#ifdef	SHIPNAMES
			pr("%s %s(#%d) tech: %d, yours is only %d\n",
				mp->m_name, ship.shp_name, ship.shp_uid,
				ship.shp_tech, tlev);
#else
			pr("%s #%d tech: %d, yours is only %d\n",
				mp->m_name, ship.shp_uid, ship.shp_tech, tlev);
#endif	SHIPNAMES
			continue;
		}
		sect.sct_avail = (sect.sct_avail * 100 - w_p_eff * 20) / 100;
		ship.shp_effic -= 35;
		ship.shp_tech = tlev;
		ship.shp_mission = 0;
		putship(ship.shp_uid, &ship);
		putsect(&sect);
		player->dolcost += (double) mp->m_cost * .15;
		pr("%s #%d upgraded to tech %d, at a cost of %d\n",
			mp->m_name, ship.shp_uid, ship.shp_tech,
			(int)(mp->m_cost * .15));
		if (ship.shp_own != player->cnum)
			wu(0,ship.shp_own,"%s #%d upgraded by %s to tech %d, at a cost of %d\n",
				mp->m_name, ship.shp_uid, cname(player->cnum),
				ship.shp_tech, (int)(mp->m_cost * .15));
	}
	if (n == 0) {
		pr("No ships\n");
		return RET_SYN;
	}
	return RET_OK;
}
