#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/empmain/COMS/RCS/terr.c,v 1.3 89/08/15 17:44:30 jeffw Exp $";
#endif

/*
 * terr.c
 *
 * designate territory of sectors
 *
 * Edward M. Rynes Esq.
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "sect.h"
#include "xy.h"
#include "nsc.h"
#include "nat.h"
#include "file.h"

terr()
{
	struct	sctstr sect;
	s_char   *p;
	int     terr_n;
	struct	nstr_sect nstr;
	s_char	prompt[128];
	s_char	buf[1024];

	if (!snxtsct(&nstr, player->argp[1]))
		return RET_SYN;
	while (nxtsct(&nstr, &sect)) {
		if (!player->owner)
			continue;
		sprintf(prompt, "%s %d%% %s  territory? ", 
	 		xyas(nstr.x, nstr.y, player->cnum),
                	sect.sct_effic, dchr[sect.sct_type].d_name);
		if ((p = getstarg(player->argp[2], prompt, buf)) == 0)
			return RET_FAIL;
		if (*p == 0)
			continue;
		terr_n = atoi(p);
		while (terr_n < 0 || terr_n > 99 || *p < '0' || *p > '9') {
			pr("Enter a number between 0 and 99!\n");
			sprintf(prompt, "%s %d%% %s  territory? ", 
				xyas(nstr.x, nstr.y, player->cnum),
				sect.sct_effic, dchr[sect.sct_type].d_name);
			if ((p = getstarg((s_char *)0, prompt, buf)) == 0)
				return RET_FAIL;
			if (*p == 0)
				break;
			terr_n = atoi(p);
		}
		if (*p == 0)
			continue;
		sect.sct_terr = terr_n;
		putsect(&sect);
	}
	return RET_OK;
}
