#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/empmain/COMS/RCS/scra.c,v 1.4 89/08/17 15:15:29 jeffw Exp $";
#endif /* not lint */

/*
 * scra.c
 *
 * Scrap ships or planes
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "ship.h"
#include "plane.h"
#include "land.h"
#include "nat.h"
#include "nsc.h"
#include "deity.h"
#include "file.h"

union item_u {
	struct shpstr ship;
	struct plnstr plane;
	struct lndstr land;
};

scra()
{
	struct	nstr_item ni;
	union	item_u item;
	int	vec[I_MAX+1];
	int	itemvec[I_MAX+1];
	int	type;
	struct	sctstr sect;
	struct	mchrstr *mp;
	struct	plchrstr *pp;
	struct	lchrstr *lp;
	s_char	*p;
	int	i;
	struct	nstr_item ni2;
	struct	plnstr plane;
	struct	sctstr sect2;
	s_char	prompt[128];
	s_char	buf[1024];

	if ((p = getstarg(player->argp[1], "Ship, land, or plane? ", buf)) == 0)
		return RET_SYN;
	type = ef_byname(p);
	if (type == EF_SECTOR)
		type = EF_SHIP;
	if (type != EF_SHIP && type != EF_PLANE && type != EF_LAND) {
		pr("Ships, land units, or planes only! (s, la, p)\n");
		return RET_SYN;
	}
	sprintf(prompt, "%s(s)? ", ef_nameof(type));
	if ((p = getstarg(player->argp[2], prompt, buf)) == 0)
		return RET_SYN;
	if (!snxtitem(&ni, type, p))
		return RET_SYN;
	if (p && (isalpha(*p) || (*p == '*') || (*p == '~') || issector(p)
		|| islist(p))){
		s_char y_or_n[80], bbuf[80];

		bzero(y_or_n,80);
		if (type == EF_SHIP)
			if (*p == '*')
				sprintf(bbuf,"all ships");
			else if (*p == '~')
				sprintf(bbuf,"all unassigned ships");
			else if (issector(p))
				sprintf(bbuf,"all ships in %s",p);
			else if (isalpha(*p))
				sprintf(bbuf,"fleet %c",*p);
			else
				sprintf(bbuf,"ships %s",p);
		else
		if (type == EF_LAND)
			if (*p == '*')
				sprintf(bbuf,"all land units");
			else if (*p == '~')
				sprintf(bbuf,"all unassigned land units");
			else if (issector(p))
				sprintf(bbuf,"all units in %s",p);
			else if (isalpha(*p))
				sprintf(bbuf,"army %c",*p);
			else
				sprintf(bbuf,"units %s",p);
		else
			if (*p == '*')
				sprintf(bbuf,"all planes");
			else if (*p == '~')
				sprintf(bbuf,"all unassigned planes");
			else if (issector(p))
				sprintf(bbuf,"all planes in %s",p);
			else if (isalpha(*p))
				sprintf(bbuf,"wing %c",*p);
			else
				sprintf(bbuf,"planes %s",p);

		sprintf(y_or_n,"Really scrap %s [n]? ", bbuf);
		if (!confirm(y_or_n))
			return RET_FAIL;
	}
	while (nxtitem(&ni, (s_char *)&item)) {
		if (!player->owner)
			continue;
		if (type == EF_SHIP) {
			getsect(item.ship.shp_x, item.ship.shp_y, &sect);
			if (sect.sct_type != SCT_HARBR)
				continue;
			if (sect.sct_effic < 60 || sect.sct_own != player->cnum)
				continue;
		}else
		if (type == EF_LAND) {
			if (item.land.lnd_ship >= 0){
				pr("%s #%d is on a ship, and cannot be scrapped!\n",lchr[item.land.lnd_type].l_name,item.land.lnd_uid);
				continue;
			}
			getsect(item.land.lnd_x, item.land.lnd_y, &sect);
		} else {
			getsect(item.plane.pln_x, item.plane.pln_y, &sect);
			if (sect.sct_type != SCT_AIRPT)
				continue;
			if (sect.sct_effic < 60 || sect.sct_own != player->cnum)
				continue;
		}
		getvec(VT_ITEM, vec, (s_char *)&sect, EF_SECTOR);
		if (type == EF_SHIP) {
			float eff;

			eff = ((float)item.ship.shp_effic/100.0);
			mp = &mchr[item.ship.shp_type];
			pr(mp->m_name);
#ifdef	SHIPNAMES
			pr(" ");
			pr(item.ship.shp_name);
#endif	SHIPNAMES
			getvec(VT_ITEM, itemvec, (s_char *)&item.ship, EF_SHIP);
			for (i = 1; i <= I_MAX; i++) {
				vec[i] += itemvec[i];
			}
			vec[I_LCM] += mp->m_lcm * 2 / 3 * eff;
			vec[I_HCM] += mp->m_hcm * 2 / 3 * eff;
			getsect(item.ship.shp_x,item.ship.shp_y,&sect2);
			snxtitem_all(&ni2, EF_PLANE);
			while (nxtitem(&ni2, (s_char *)&plane)){
				if (plane.pln_own == 0)
					continue;

				if (plane.pln_ship == item.ship.shp_uid){
					wu(0,plane.pln_own,"Plane %d transferred off ship %d to %s\n",ni2.cur,item.ship.shp_uid,xyas(plane.pln_x, plane.pln_y,player->cnum));
					plane.pln_ship = -1;
					if(sect2.sct_own != plane.pln_own){
						wu(0,plane.pln_own,"%s #%d given to %s\n",plchr[plane.pln_type].pl_name,plane.pln_uid,cname(sect2.sct_own));
						wu(0,sect2.sct_own,"%s #%d given to you by %s\n",plchr[plane.pln_type].pl_name,plane.pln_uid,cname(player->cnum));
					}
					plane.pln_own = sect2.sct_own;
					putplane(plane.pln_uid, (s_char *)&plane);
				}
			}
			item.ship.shp_own = 0;
			putship(item.ship.shp_uid, (s_char *)&item.ship);
		} else
		if (type == EF_LAND) {
			float eff;
			eff = ((float)item.land.lnd_effic/100.0);
			lp = &lchr[item.land.lnd_type];
			pr(lp->l_name);
			getvec(VT_ITEM, itemvec, (s_char *)&item.land, EF_LAND);
			for (i = 1; i <= I_MAX; i++) {
				vec[i] += itemvec[i];
			}
			vec[I_MILIT] += total_mil(&item.land);
			vec[I_GUN] += lp->l_gun * 2 / 3 * eff;
			vec[I_SHELL] += lp->l_shell * 2 / 3 * eff;
			vec[I_LCM] += lp->l_lcm * 2 / 3 * eff;
			vec[I_HCM] += lp->l_hcm * 2 / 3 * eff;
			getsect(item.land.lnd_x,item.land.lnd_y,&sect2);
			snxtitem_all(&ni2, EF_PLANE);
			while (nxtitem(&ni2, (s_char *)&plane))
				if (plane.pln_land == item.land.lnd_uid){
					wu(0,plane.pln_own,"Plane %d transferred off land unit %d to %s\n",ni2.cur,item.land.lnd_uid,xyas(plane.pln_x, plane.pln_y,player->cnum));
					plane.pln_land = -1;
					putplane(plane.pln_uid, (s_char *)&plane);
				}
			item.land.lnd_own = 0;
			putland(item.land.lnd_uid, (s_char *)&item.land);
		} else {
			float eff;

			eff = ((float)item.land.lnd_effic/100.0);
			pp = &plchr[item.plane.pln_type];
			pr(pp->pl_name);
			vec[I_LCM] += pp->pl_lcm * 2 / 3 * eff;
			vec[I_HCM] += pp->pl_hcm * 2 / 3 * eff;
			vec[I_MILIT] += pp->pl_crew;
			item.plane.pln_own = 0;
			putplane(item.plane.pln_uid, (s_char *)&item.plane);
		}
#ifdef	SHIPNAMES
		pr("(#%d) scrapped in %s\n", ni.cur,
#else
		pr(" #%d scrapped in %s\n", ni.cur,
#endif	SHIPNAMES
			xyas(sect.sct_x, sect.sct_y, player->cnum));
		putvec(VT_ITEM, vec, (s_char *)&sect, EF_SECTOR);
		putsect(&sect);
	}
	return RET_OK;
}
