#ifndef lint
static char *RCSid = "$Header: /SRX/empire/EMP/player/commands/reje.c 1.0 90/03/17 10:08:15 bailey Exp $";
#endif /* not lint */

/*
 * reje.c
 *
 * Refuse to accept either telegrams or treaties from individual
 * countries. Adapted from decl.c
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "player.h"
#include "nat.h"
#include "news.h"
#include "file.h"
#include "xy.h"
#include "nsc.h"


reje()
{
	register s_char *p;
	int	rel;
	int	do_undo;
	struct	natstr nat;
	struct	nstr_item ni;
	s_char	buf[1024];

	p = getstarg(player->argp[1], "reject or accept? ", buf);
	switch (*p) {
	case 'r':
		do_undo = 1;
		break;
	case 'a':
		do_undo = 0;
		break;
	default:
		pr("That's not one of the choices!\n");
		return RET_SYN;
	}
	p = getstarg(player->argp[2], "mail, treaties, loans, or announcements? ", buf);
	switch (*p) {
	case 'a':
		rel = REJ_ANNO;
		break;
	case 'l':
		rel = REJ_LOAN;
		break;
	case 'm':
		rel = REJ_TELE;
		break;
	case 't':
		rel = REJ_TREA;
		break;
	default:
		pr("That's not one of the choices!\n");
		return RET_SYN;
	}
	if (!snxtitem(&ni, EF_NATION, player->argp[3]))
		return RET_SYN;
	while (nxtitem(&ni, (s_char *) &nat)) {
		if (nat.nat_stat & STAT_NORM == 0)
			continue;
		switch(rel){
			case REJ_ANNO: pr("%s annos from %s\n",(do_undo == 1 ? "Rejecting" : "Accepting"),nat.nat_cnam);
					break;
			case REJ_LOAN: pr("%s loans from %s\n",(do_undo == 1 ? "Rejecting" : "Accepting"),nat.nat_cnam);
					break;
			case REJ_TELE: pr("%s teles from %s\n",(do_undo == 1 ? "Rejecting" : "Accepting"),nat.nat_cnam);
					break;
			case REJ_TREA: pr("%s treaties from %s\n",(do_undo == 1 ? "Rejecting" : "Accepting"),nat.nat_cnam);
					break;
			}
		setrej(player->cnum, (natid)ni.cur, do_undo, rel);
	}
	return RET_OK;
}
