#ifndef lint
static char *RCSid = "$Header: dist.c,v 1.10 89/10/16 20:24:19 mr-frog Exp $";
#endif /* not lint */

/*
 * dist.c
 *
 * name distribution sector (by a pathname) for a given
 * range of sectors (individually)
 *
 * Dave Pare, 1986
 *
 * Rewritten to use dist sector & BestPath stuff instead of paths.
 * --ts Jan 1993
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "nsc.h"
#include "nat.h"
#include "file.h"
#include "path.h"

/*
 * distribute <SECT> <DISTSECT|.|h>
 */
dist()
{
	struct	sctstr sect, dsect, tsect;
	struct	nstr_sect nstr;
	s_char	*path, *p, *BestDistPath(), *BestLandPath(), *bestownedpath();
	double	move_cost=0.0;
	coord	dstx, dsty;
	s_char	buf[1024];

	if (!snxtsct(&nstr, player->argp[1]))
		return RET_SYN;
	while (!player->aborted && nxtsct(&nstr, &sect)) {
		if (!player->owner)
			continue;
		pr("%s at %s ", dchr[sect.sct_type].d_name,
			xyas(nstr.x, nstr.y, player->cnum));
		if ((sect.sct_dist_x != sect.sct_x) ||
			(sect.sct_dist_x != sect.sct_x)){
			getsect(sect.sct_dist_x, sect.sct_dist_y, &tsect);
			if (tsect.sct_own != player->cnum)
				pr("distributes to %s, not owned by you.\n",
					xyas(tsect.sct_x, tsect.sct_y, player->cnum));
			else
				pr("distributes to %s. \n",
					xyas(tsect.sct_x, tsect.sct_y, player->cnum));
		} else
			pr("has no dist sector. \n");
		p = getstarg(player->argp[2], "Distribution sector? ", buf);
		if (p && (*p == 0))
			continue;

		if (p && (*p != '.') && (*p != 'h') &&
			(!sarg_xy(p, &dstx, &dsty)))
			return RET_SYN;

		if (p && ((*p == '.') || (*p == 'h'))){
			dstx = sect.sct_x;
			dsty = sect.sct_y;
		}

		if (!getsect(dstx,dsty,&dsect)){
			pr("Bad sector.\n");
			return RET_FAIL;
		}

		if (dsect.sct_own != player->cnum)
			pr("Warning: you don't own %s!\n",
				xyas(dsect.sct_x,dsect.sct_y,player->cnum));

		path = BestDistPath(buf, &sect,&dsect,&move_cost);

		if (path == (s_char *)0){
			pr("No owned path from %s to %s.\n",
				xyas(dsect.sct_x,dsect.sct_y,player->cnum),
				xyas(sect.sct_x,sect.sct_y,player->cnum));
			continue;
		}

		if ((dsect.sct_x == sect.sct_x) &&
			(dsect.sct_y == sect.sct_y)) {
			pr("Distribution from and to %s %s terminated\n",
					dchr[sect.sct_type].d_name,
					xyas(sect.sct_x, sect.sct_y, player->cnum));
		} else {
			pr("%s %s new path distributes to %s (cost %1.3f)\n", 
					dchr[sect.sct_type].d_name,
					xyas(sect.sct_x, sect.sct_y, player->cnum),
					xyas(dsect.sct_x, dsect.sct_y, player->cnum),
					move_cost);
			pr("\tCurrent best path is '%s'\n", path);

			if (dsect.sct_own==player->cnum && dsect.sct_type != SCT_WAREH)
				pr("\tWarning: %s not a warehouse!\n",
					xyas(dsect.sct_x, dsect.sct_y, player->cnum));
		}
		sect.sct_dist_x = dsect.sct_x;
		sect.sct_dist_y = dsect.sct_y;
		pr("\n");
		putsect(&sect);
	}
	return RET_OK;
}
