#ifndef lint
static char *RCSid = "$Header: /users/empire/EMP/empmain/COMS/RCS/demo.c,v 1.4 89/06/09 03:33:07 empire Exp $";
#endif /* not lint */

/*
 * demo.c
 *
 * de-mobilize "n" military in a given sector.
 * You get to pay $5/mil for "GI Bill", and the
 * sector must have at least 60% efficiency.
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "player.h"
#include "xy.h"
#include "deity.h"
#include "var.h"
#include "sect.h"
#include "nat.h"
#include "nsc.h"
#include "file.h"

/*
 * format: demo <SECTS> number
 *
 */
demo()
{
	struct	natstr *natp;
	struct	nstr_sect nstr;
	struct	sctstr sect;
	int	mil_demob;
	int	mil;
	int	civ;
	int	deltamil;
	int	number;
	s_char	*p;
	int	reserves;
	s_char	buf[1024];

	natp = getnatp(player->cnum);
	if (!snxtsct(&nstr, player->argp[1]))
		return RET_SYN;
	if ((p = getstarg(player->argp[2], "Number to de-mobilize : ", buf)) == 0)
		return RET_SYN;
	number = atoi(p);
	if (!(p = getstarg(player->argp[3], "New civilians on active reserve? (y/n) ", buf)))
		return RET_SYN;
	if (*p != 'y' && *p != 'n')
		return RET_SYN;
	mil_demob = 0;
	reserves = 0;
	while (nxtsct(&nstr, &sect)) {
		if (!player->owner || sect.sct_effic < 60)
			continue;
		if ((mil = getvar(V_MILIT, (s_char *)&sect, EF_SECTOR)) == 0)
			continue;
		if (sect.sct_own != sect.sct_oldown)
			continue;
		civ = getvar(V_CIVIL, (s_char *)&sect, EF_SECTOR);
		if (number < 0){
			if ((deltamil = mil + number) <= 0)
				continue;
		}
		else if ((deltamil = min(mil, number)) <= 0)
			continue;
		civ += deltamil;
		mil -= deltamil;
		mil_demob += deltamil;
		player->dolcost += deltamil * 5;
		pr("%d demobilized in %s (%d mil left)\n",
			deltamil, xyas(sect.sct_x, sect.sct_y, player->cnum), mil);
		if (*p == 'y')
			reserves += deltamil;
		putvar(V_MILIT, mil, (s_char *)&sect, EF_SECTOR);
		putvar(V_CIVIL, civ, (s_char *)&sect, EF_SECTOR);
		putsect(&sect);
	}
	if (!mil_demob) {
		pr("No eligible sectors/military for demobilization\n");
		return RET_FAIL;
	}
	pr("Total new civilians : %d\n", mil_demob);
	if (*p == 'y')
		pr("Military reserve stands at %d (up %d)\n",
			natp->nat_reserve + reserves, reserves);
	if (reserves > 0) {
		natp->nat_reserve += reserves;
		putnat(natp);
	}
	return RET_OK;
}
