#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/player/commands/RCS/coas.c,v 1.12 89/09/10 21:59:20 mr-frog Exp $";
#endif /* not lint */

/*
 * coas.c
 *
 * look at all ships in world.
 *
 * Keith Muller, 1983
 * and Dave Pare, 1986
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "sect.h"
#include "ship.h"
#include "nat.h"
#include "xy.h"
#include "nsc.h"
#include "file.h"

#define	TSIZE	200

struct coast {
	struct coast *c_next;
	int c_spotted;
	int c_number;
	struct shpstr c_shp;
};

static	showship();

/*
 * format: coastwatch [<SECTS>]
 */
coas()
{
	struct sctstr sect;
	struct nstr_sect nstr;
	struct coast *cp;
	struct coast *list[TSIZE];
	int i, k, j, n;
	int vrange, see;
	int x, y;
	int mink, minj, maxk, maxj;
	int nship = 0;
	float tech;
	struct	nstr_item ni;

	if (snxtsct(&nstr, player->argp[1]) == 0)
		return RET_SYN;
	for (i = 0; i < TSIZE; i++)
		list[i] = 0;
	cp = (struct coast *)malloc(sizeof(*cp));
	snxtitem_all(&ni, EF_SHIP);
	while (nxtitem(&ni, (s_char *) &cp->c_shp)) {
		if (cp->c_shp.shp_own == 0 || cp->c_shp.shp_own == player->cnum)
			continue;
		/*
		 * don't bother putting subs in the table...
		 * unless they're in a sector you own (harbor or such)
		 */
		getsect(cp->c_shp.shp_x, cp->c_shp.shp_y, &sect);
		if ((mchr[cp->c_shp.shp_type].m_flags & M_SUB) && 
			(sect.sct_own != player->cnum))
			continue;
		n = scthash(cp->c_shp.shp_x, cp->c_shp.shp_y, TSIZE);
		cp->c_spotted = 0;
		cp->c_number = i;
		cp->c_next = list[n];
		list[n] = cp;
		cp = (struct coast *)malloc(sizeof(*cp));
		nship++;
	}
	/* get that last one! */
	free((s_char *)cp);
	pr("- = [ Coastwatch report for %s ] = -\n", cname(player->cnum));
	pr("  Country            Ship          Location\n");
	tech = tfact(player->cnum, 1.0);
	while (nxtsct(&nstr, &sect) && nship) {
		if (sect.sct_own != player->cnum)
			continue;
		see = sect.sct_type == SCT_RADAR ? 14 : 4;
		vrange = (int) (sect.sct_effic / 100.0 * see * tech);
		if (vrange < 1)
			vrange = 1;
		maxk = vrange;
		maxj = vrange * 2;
		vrange *= vrange;
		mink = -maxk;
		minj = -maxj;
		for (j = minj; j <= maxj && nship; j++) {
			x = xnorm(sect.sct_x + j);
			for (k = mink; k <= maxk && nship; k++) {
				if ((j + k) & 01)
					 continue;
				/* quick range check to save time... */
				if (vrange < (j * j + 3 * k * k) / 4)
					continue;
				y = ynorm(sect.sct_y + k);
				n = scthash(x, y, TSIZE);
				if (list[n] == 0)
					continue;
				nship -= showship(&list[n], x, y);
			}
		}
	}
	/* free up the coast structs calloc'ed above */
	for (i = 0; i < TSIZE; i++) {
		while (cp = list[i]) {
			list[i] = cp->c_next;
			free((s_char *)cp);
		}
	}
	return RET_OK;
}

static
showship(cpp, x, y)
	struct	coast **cpp;
	int	x;
	int	y;
{
	register struct coast *cp;
	register struct coast *todelete = 0;
	register struct coast **prev;
	register struct mchrstr *mcp;
	s_char	*name;
	int	nship = 0;

	prev = 0;
	cp = *cpp;
	prev = cpp;
	do {
		/* we delete it, we free it. */
		if (todelete) {
			free((s_char *)todelete);
			todelete = 0;
		}
		if (cp->c_shp.shp_x != x || cp->c_shp.shp_y != y) {
			prev = &(*prev)->c_next;
			continue;
		}
		mcp = &mchr[cp->c_shp.shp_type];
		if (mcp->m_flags & M_FOOD)
			name = "fishing vessel";
		else
			name = mcp->m_name;
		pr(" %12.12s (#%3d) %s #%d @ %s\n",
			cname(cp->c_shp.shp_own), cp->c_shp.shp_own,
			name, cp->c_shp.shp_uid, xyas(x, y, player->cnum));
		*prev = cp->c_next;
		todelete = cp;
		nship++;
	} while (cp = cp->c_next);
	/* check that last one! */
	if (todelete)
		free((s_char *)todelete);
	return (nship);
}
