#ifndef lint
static char *RCSid = "$Header: best.c,v 1.1 89/12/14 08:19:39 jay Exp $";
#endif /* not lint */

/*
 * best.c
 *
 * show best path from x1,y1 to x2,y2
 *
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "sect.h"
#include "item.h"
#include "xy.h"
#include "path.h"
#include "nsc.h"
#include "deity.h"
#include "file.h"
#include "nat.h"

best()
{
	double	cost;
	s_char	*BestDistPath(), *BestLandPath(), *s;
	struct	sctstr s1, s2;
	struct	nstr_sect nstr, nstr2;
	int	dist=0;
	s_char	buf[1024];

	dist = player->argp[0][4] == 'd';

	if (!snxtsct(&nstr, player->argp[1]))
		return RET_SYN;

	if (!snxtsct(&nstr2, player->argp[2]))
		return RET_SYN;

	while (!player->aborted && nxtsct(&nstr, &s1)){
		if (s1.sct_own != player->cnum)
			continue;
		snxtsct(&nstr2, player->argp[2]);
		while (!player->aborted && nxtsct(&nstr2, &s2)){
			if (s2.sct_own != player->cnum)
				continue;
			if (dist)
				s = BestDistPath(buf, &s1,&s2,&cost);
			else
				s = BestLandPath(buf, &s1,&s2,&cost);
			if (s != (s_char *)0)
				pr("Best %spath from %s to %s is %s (cost %1.3f)\n",
					(dist ? "dist" : ""),
					xyas(s1.sct_x,s1.sct_y,player->cnum),
					xyas(s2.sct_x,s2.sct_y,player->cnum), s, cost);
			else
				pr("No owned path from %s to %s exists!\n",
					xyas(s1.sct_x,s1.sct_y,player->cnum),
					xyas(s2.sct_x,s2.sct_y,player->cnum));
		}
	}
	return 0;
}
