#include <stdio.h>
#include "as.h"
#include "misc.h"

#if !defined(lint) && !defined(SABER)
static	char	sccsid[] = "@(#)as_delete.c	1.5	11/13/90";
#endif /* not lint */

static	void	as_free_queue();
static	void	as_free_path();

/*
 * Free any dynamically allocated data stored in the as_data structure.
 */
void
as_reset(adp)
	struct as_data	*adp;
{

	as_free_queue(adp->head);
	adp->head = NULL;
	as_free_queue(adp->tried);
	adp->tried = NULL;
	as_free_queue(adp->subsumed);
	adp->subsumed = NULL;
	as_free_hashtab(adp);
	as_free_path(adp->path);
	adp->path = NULL;
}

/*
 * Free a queue (either the main, subsumed, or tried).
 */
static void
as_free_queue(queue)
	struct as_queue	*queue;
{
	struct as_queue	*qp, *qp2;

	for (qp = queue; qp; qp = qp2) {
		free((s_char *)qp->np);
		qp2 = qp->next;
		free((s_char *)qp);
	}
}

/*
 * Free a path.
 */
static void
as_free_path(pp)
	struct as_path	*pp;
{
	struct as_path	*pp2;

	for (; pp; pp = pp2) {
		pp2 = pp->next;
		free((s_char *)pp);
	}
}

/*
 * Delete the as_data structure (which includes freeing its data).
 */
void
as_delete(adp)
	struct	as_data	*adp;
{
	as_reset(adp);
	free((s_char *)adp->neighbor_coords);
	free((s_char *)adp->neighbor_nodes);
	free((s_char *)adp->hashtab);
	free((s_char *)adp);
}
