.TH Command MARCH
.SY "march <LAND UNIT/ARMY> <ROUTE|DESTINATION>"
The march command is the \*Qmove\*U command applied to land units.
You can control one unit or an entire army with it.
.s3
Land units may only move into sectors you own.
If you are moving an army and the lead unit stops, the army stops;
(the lowest numbered unit is always considered the lead unit).
.s1
The program will prompt with the mobility of the lead unit,
the minimum mobility value for the army, and the current sector
coordinates in the form:
.NF
<57.0:23.5: -6,4>
.FI
which means the lead unit has 57 mobility units,
some other unit in the army has 23.5 mobility units and
the lead unit is in sector -6,4.
You may indicate the direction you would like the army to move
by typing a string of letters consisting of any combination of the
following:
.NF
y  for up-left
u  for up-right               y    u
g  for left                    \\\\  /
j  for right               g  --  --  j
b  for down-left               /  \\\\
n  for down-right             b    n
r  for radar
l  for lookout
m  to sweep landmines
h  for end of movement
.FI
.s3
The radar option will cause the lead unit to use it's radar, if any.
You may also give a unit number or army or group of units on the same
line: "r 12/13/14/73"
.s3
The lookout option works in the same way as radar, i.e. it will cause the
lead unit to do a lookout.
.s3
Note: the lookout and radar commands use BTU's, just as if you'd typed them
separately from the command line.
.s3
You may also use the 'm' command to have engineers in the marching
group search for mines in the current sector. Example: "m 12"
.s3
Since the <ROUTE> can be specified in the command line,
simple unit movements are often typed as a single line, such as:
.EX march 19 jjjh
.s3
Or some movements may be done partly on the command line and partly
interactively:

.EX march 18 yy
.NF
<112.7:112.7: -4, -2> l
Your capital 100% efficient with 549 civ with 10 mil @ -5,-3
Your highway 100% efficient with 549 civ with 0 mil @ -4,-2
Your harbor 100% efficient with 549 civ with 109 mil @ -3,-1
<112.7:112.7: -4, -2> yh
war band #18 stopped at -5,-3
.FI
.s3
You may also simply specify the destination sector
on the command line. In this case,
empire will set the path to be the cheapest path (in terms of
mobility) that currently exists. The unit(s) will move to the
destination sector, and then ask for more input.
.s3
For example,
.EX march 18 -6,-2
.NF
<104.2:104.2: -6,-2> h
war band #18 stopped at -5,-3
.FI
.s3
Note that if you are marching multiple units, you may only specify a
destination sector on the command line if all the units start in the
same sector.
.s1
The formula for the movement cost for 1 sector is:
.NF

 (480 / (( speed + speed * ((50+tech)/(200+tech)) ) * Efficiency/100)) *
	(sector cost * 5)

.FI
.s1
The sector cost depends on the sector type, efficiency, and move cost.
(The sector move cost can be seen with show sector stats)
.s1
The exact formula is:

	sector cost = ((move cost) * 100 - efficiency) / 500.0;

	minimum 0.01
.s3
For example, a park sector has a move cost of 2. At 100% efficiency,
the sector cost is: ((2) * 100 - 100) / 500 = 0.2
.s3
So, for a 100% efficient, speed 32, tech 0 unit to enter a 100% park, the mobility used would be:
.NF
 (480 / ((32 + 32 * ((50+0)/(200+0)) ) * 100/100)) * (.2 * 5) = 12
.FI
.s1
At the update, units with negative mobility have their mobility halved
before new mob is added. For example, in a game where units got 32 mob
per update, a unit with -100 mobility would have -18 after an update.
(-100/2 = -50 + 32 = -18) This helps inefficient units be not quite as
slow.
.s1
Moving a unit through a sector that has been mined
introduces a 5% chance per mine (cumulative) that you will be damaged
by \*Qdetecting\*U one of the little cuties.
Units with engineering capabilities can remove up to five mines per
pass through a sector (indicated by the message \*QSweep...\*U).
Such units also take 1/2 normal damage from mines.
See info lmine for more details.
.s3
See also : unit-types, lmine
