/*
 * loan.h
 *
 * things having to do with loans.
 *
 * from PSL Empire, 1985
 * $Revision: 1.6 $ $Date: 89/06/01 14:18:23 $
 */

#define	MAXLOAN		100000
#define SECS_PER_DAY	(60*60*24)

struct	lonstr {
	natid	l_loner;	/* loan shark */
	natid	l_lonee;	/* sucker */
	s_char	l_status;	/* loan status */
	short	l_sell;		/* pointer to trade file */
	int	l_irate;	/* interest rate */
	int	l_ldur;		/* intended duration */
	long	l_amtpaid;	/* amount paid so far */
	long	l_amtdue;	/* amount still owed */
	time_t	l_lastpay;	/* date of most recent payment */
	time_t	l_duedate;	/* date after which interest doubles, etc */
};

#define LS_FREE		0
#define LS_PROPOSED	1
#define LS_SIGNED	2

#define getloan(n, lp) \
	ef_read(EF_LOAN, n, (caddr_t)lp)
#define putloan(n, lp) \
	ef_write(EF_LOAN, n, (caddr_t)lp)
#define getloanp(n) \
	(struct lonstr *) ef_ptr(EF_LOAN, n)
