/* Win.h */

#ifndef _win_h_
#define _win_h_ 1

/* For Error(): */
#define kDoPerror		1
#define kDontPerror		0

#define kUseDefaultPrompt NULL
#define kLineModePrompt "esh"
#define kPromptTail ": "
#define kPromptLimit 45

#ifdef HAVE_STDARG_H
void DebugMsg(char *fmt0, ...);
void TraceMsg(char *fmt0, ...);
void PrintF(char *fmt0, ...);
void MultiLinePrintF(char *fmt0, ...);
void BoldPrintF(char *fmt0, ...);
void EPrintF(char *fmt0, ...);
void Error(int pError0, char *fmt0, ...);
#else
void DebugMsg();
void TraceMsg();
void PrintF();
void MultiLinePrintF();
void BoldPrintF();
void EPrintF();
void Error();
#endif

void EndWin(void);
void Exit(int);
void SaveScreen(void);
void RestoreScreen(int);
void Beep(int);
void UpdateScreen(int);
void FlushListWindow(void);
char *Gets(char *, size_t);
void GetAnswer(char *, char *, size_t, int);
void SetBar(char *, char *, char *, int, int);
void SetDefaultBar(void);
void SetScreenInfo(void);
void PrintToListWindow(char *, int);
void MultiLineInit(void);
void MakeBottomLine(char *, int, int);
void SetPrompt(char *);
void InitWindows(void);

#endif	/* _win_h_ */
