/* Tips.c */

#include "Sys.h"

#include <ctype.h>

#include "Util.h"
#include "Tips.h"

extern int gScreenWidth;

static char *gTipList[] = {

"You can abbreviate host names if you've opened them at least once before. \
If you opened wuarchive.wustl.edu yesterday, you could try just \"open wuarchive\" \
or just \"open wu\" today.",

"You can roll your own commands by using global macros.  Create a file called \
\"macros\" in your .esh directory and put your macros in it.",

"If you miss the old \"start.exec\" alises which \"pei\" ran when a specific \
site was opened, you can still do it with esh.  You need to put macros in \
your \"macros\" file named \".open.<sitename>\" where <sitename> is the nickname \
assigned to the host.",

"The \"open\" command accepts several flags.  Do a \"help open\" for details.",

"Use the \"more\" command to view a remote file with your pager.",

#ifdef SYSLOG
"esh may be keeping detailed information on everything you transfer. \
Run the \"version\" command and if you see SYSLOG, your actions are being \
recorded on the system log.",
#endif

/* Weight this one a little more. */

"You can get the newest version of esh from ftp.empire.net, in the \
/pub/empire/player/clients directory.  esh is FREEware!",

"You can get the newest version of esh from ftp.empire.net, in the \
/pub/empire/player/clients directory.  esh is FREEware!",

"You can get the newest version of esh from ftp.empire.net, in the \
/pub/empire/player/clients directory.  esh is FREEware!",

"To report a bug, mail your message to children@empire.net.  Include the \
output of the \"version\" command in your message.  An easy way to do that \
is to compose your message, then do a \"esh -H >> msg.\"",

/* Weight this one a little more */

"If you need to report a bug, send me a ~/.esh/trace file too.  To enable \
tracing, turn on trace logging from the Prefs window, or type \"set trace 1\" \
from the command line. Then re-create your bug, quit the program, and \
send the trace file to children@empire.net.",

"If you need to report a bug, send me a ~/.esh/trace file too.  To enable \
tracing, turn on trace logging from the Prefs window, or type \"set trace 1\" \
from the command line. Then re-create your bug, quit the program, and \
send the trace file to children@empire.net.",

"esh will write all sorts of cool debugging information to a file named \
\"trace\" in your .esh directory if you do a \"set trace 1\" at the start.",

"Sick and tired of these tips?  Type \"set tips 0\" any time."
};

void PrintTip(char *tip)
{
	char buf[256];
	char *cp, *dp;
	int i, sWidth, lines;
	
	sWidth = gScreenWidth - 2;
	for (cp = tip, lines = 0; *cp != '\0'; ++lines) {
		while (isspace(*cp))
			cp++;

		dp = buf;
		if (lines == 0) {
			strcpy(dp, "Tip: ");
			i = 5;
			dp += i;
		} else {
			strcpy(dp, "     ");
			i = 5;
			dp += i;
		}
		
		for ( ; (*cp != '\0') && (i<sWidth); i++)
			*dp++ = *cp++;

		if (*cp != '\0') {
			cp--;
			while (!isspace(*cp)) {
				cp--;
				dp--;
			}
		}
		*dp = '\0';
		
		MultiLinePrintF("%s\n", buf);
	}
	MultiLinePrintF("\n");
}	/* PrintTip */




void PrintRandomTip(void)
{
	char *tip;
	int tipNum;
	
	tipNum = rand() % NTIPS;
	tip = gTipList[tipNum];
	PrintTip(tip);
}	/* PrintRandomTip */






void PrintAllTips(void)
{
	char *tip;
	int tipNum;
	
	for (tipNum = 0; tipNum < NTIPS; tipNum++) {
		tip = gTipList[tipNum];
		PrintTip(tip);
	}
}	/* PrintAllTips */
