/* Mail.h */

#ifndef _mail_h_
#define _mail_h_ 1

#define kMailSubjLen 30

typedef struct Mail {
	unsigned char type;
	unsigned char status;
	str32 country;
	unsigned short cnum;
	char weekday[4];
	char month[4];
	unsigned char day;
	char time[9];
	unsigned short year;
	string header;
	LineList mailData;
	char subj[kMailSubjLen];
	unsigned char subjlen;
} Mail, *MailPtr;

typedef struct MailList {
	longstring fName;
	FILE *fp;
	MailPtr mail;
	int current;
	int last;
	size_t size;
} MailList, *MailListPtr;

#define kMailProd  0
#define kMailBull  1
#define kMailTele  2
#define kMailAnno  3
#define kMailUndef 4

#define kMessageNew     0
#define kMessageRead    1
#define kMessageUnread  2
#define kMessageReplied 3
#define kMessageDeleted 4

#define kNewStatus(mp) (mp->status == undelete ? (mp->status == kMessageDeleted) ? kMessageUnread : mp->status : kMessageDeleted)

#define kMailBlockSize ((size_t)512)

#define kMailHeaderChar '>'

#endif  /* _mail_h_ */
