/* Cpp.c */

#include "Sys.h"
#include "Util.h"
#include "RCmd.h"
#include "Cpp.h"

/* List of CPP symbols that we would like to have show up when we print
 * ther version information.  Some of these are the program's, and others
 * are OS defined symbols.
 *
 * If the compiler chokes in this part, it's probably because the symbol
 * in question was the wrong type (was i when should be s, or vice versa).
 * If you get into trouble, just change the entry for the symbol from
 * using the "i" or "s" macro to use the "b" macro instead.
 *
 * Hopefully that won't happen, since most symbols use the "b" macro
 * below, which doesn't try to use the value of the symbol.  The "i" and
 * "s" macros do use the value, which is nice because then we'll be able
 * to see the value of the symbol when we dump the symbol list.
 */

#define i(a,b) { a, 0, (long) b, NULL },
#define s(a,b) { a, 1, 0L, (char *)b },
#define b(a,b) { a, 0, (long) 1, NULL },

CppSymbol gCppSymbols[] = {
#ifdef A_BOLD
	b("A_BOLD", A_BOLD)
#endif
#ifdef A_DIM
	b("A_DIM", A_DIM)
#endif
#ifdef A_NORMAL
	b("A_NORMAL", A_NORMAL)
#endif
#ifdef A_REVERSE
	b("A_REVERSE", A_REVERSE)
#endif
#ifdef A_UNDERLINE
	b("A_UNDERLINE", A_UNDERLINE)
#endif
#ifdef _AIX
	b("_AIX", _AIX)
#endif
#ifdef AIX
	b("AIX", AIX)
#endif
#ifdef apollo
	b("apollo", apollo)
#endif
#ifdef aux
	b("aux", aux)
#endif
#ifdef __Besta__
	b("__Besta__", __Besta__)
#endif
#ifdef _BSD
	b("_BSD", _BSD)
#endif
#ifdef BSD
	b("BSD", BSD)
#endif
#ifdef __bsdi__
	b("__bsdi__", __bsdi__)
#endif
#ifdef BSD_GETPGRP
	b("BSD_GETPGRP", BSD_GETPGRP)
#endif
#ifdef BULL
	b("BULL", BULL)
#endif
#ifdef CANNOT_HIDE_TEXT
	b("CANNOT_HIDE_TEXT", CANNOT_HIDE_TEXT)
#endif
#ifdef USE_CURSES
	i("USE_CURSES", USE_CURSES)
#endif
#ifdef DEBUG
	b("DEBUG", DEBUG)
#endif
#ifdef __dgux
	b("__dgux", __dgux)
#endif
#ifdef DGUX
	b("DGUX", DGUX)
#endif
#ifdef DOMAINNAME
	s("DOMAINNAME", DOMAINNAME)
#endif
#ifdef DYNIX
	b("DYNIX", DYNIX)
#endif
#ifdef DYNIXPTX
	b("DYNIXPTX", DYNIXPTX)
#endif
#ifdef __FreeBSD__
	b("__FreeBSD__", __FreeBSD__)
#endif
#ifdef EMPIRE_PORT
	i("EMPIRE_PORT", EMPIRE_PORT)
#endif
#ifdef __GNUC__
	i("__GNUC__", __GNUC__)
#endif
#ifdef GZCAT
	s("GZCAT", GZCAT)
#endif
#ifdef HAVE_FCNTL_H
	b("HAVE_FCNTL_H", HAVE_FCNTL_H)
#endif
#ifdef HAVE_GETDOMAINNAME
	b("HAVE_GETDOMAINNAME", HAVE_GETDOMAINNAME)
#endif
#ifdef HAVE_GETCWD
	b("HAVE_GETCWD", HAVE_GETCWD)
#endif
#ifdef HAVE_GETWD
	b("HAVE_GETWD", HAVE_GETWD)
#endif
#ifdef HAVE_LIBC_S
	b("HAVE_LIBC_S", HAVE_LIBC_S)
#endif
#ifdef HAVE_LIBCURSES
	b("HAVE_LIBCURSES", HAVE_LIBCURSES)
#endif
#ifdef HAVE_LIBNCURSES
	b("HAVE_LIBNCURSES", HAVE_LIBNCURSES)
#endif
#ifdef HAVE_LIBTERMCAP
	b("HAVE_LIBTERMCAP", HAVE_LIBTERMCAP)
#endif
#ifdef HAVE_LIBTERMNET
	b("HAVE_LIBTERMNET", HAVE_LIBTERMNET)
#endif
#ifdef HAVE_LIBREADLINE
	b("HAVE_LIBREADLINE", HAVE_LIBREADLINE)
#endif
#ifdef HAVE_LIBGETLINE
	b("HAVE_LIBGETLINE", HAVE_LIBGETLINE)
#endif
#ifdef HAVE_LIBRESOLV
	b("HAVE_LIBRESOLV", HAVE_LIBRESOLV)
#endif
#ifdef HAVE_LIBNSL
	b("HAVE_LIBNSL", HAVE_LIBNSL)
#endif
#ifdef HAVE_LIBSOCKS
	b("HAVE_LIBSOCKS", HAVE_LIBSOCKS)
#endif
#ifdef HAVE_MEMMOVE
	b("HAVE_MEMMOVE", HAVE_MEMMOVE)
#endif
#ifdef HAVE_MKTIME
	b("HAVE_MKTIME", HAVE_MKTIME)
#endif
#ifdef HAVE_POLL
	b("HAVE_POLL", HAVE_POLL)
#endif
#ifdef HAVE_READLINE_HISTORY_H
	b("HAVE_READLINE_HISTORY_H", HAVE_READLINE_HISTORY_H)
#endif
#ifdef HAVE_SELECT
	b("HAVE_SELECT", HAVE_SELECT)
#endif
#ifdef HAVE_STDARG_H
	b("HAVE_STDARG_H", HAVE_STDARG_H)
#endif
#ifdef HAVE_STRCASECMP
	b("HAVE_STRCASECMP", HAVE_STRCASECMP)
#endif
#ifdef HAVE_STRERROR
	b("HAVE_STRERROR", HAVE_STRERROR)
#endif
#ifdef HAVE_STRFTIME
	b("HAVE_STRFTIME", HAVE_STRFTIME)
#endif
#ifdef HAVE_STRING_H
	b("HAVE_STRING_H", HAVE_STRING_H)
#endif
#ifdef HAVE_SYMLINK
	b("HAVE_SYMLINK", HAVE_SYMLINK)
#endif
#ifdef HAVE_SYS_IOCTL_H
	b("HAVE_SYS_IOCTL_H", HAVE_SYS_IOCTL_H)
#endif
#ifdef HAVE_SYS_SELECT_H
	b("HAVE_SYS_SELECT_H", HAVE_SYS_SELECT_H)
#endif
#ifdef HAVE_SYS_TIME_H
	b("HAVE_SYS_TIME_H", HAVE_SYS_TIME_H)
#endif
#ifdef HAVE_TERMIO_H
	b("HAVE_TERMIO_H", HAVE_TERMIO_H)
#endif
#ifdef HAVE_TERMIOS_H
	b("HAVE_TERMIOS_H", HAVE_TERMIOS_H)
#endif
#ifdef HAVE_TERMNET_H
	b("HAVE_TERMNET_H", HAVE_TERMNET_H)
#endif
#ifdef HAVE_TERM_TERMNET_H
	b("HAVE_TERM_TERMNET_H", HAVE_TERM_TERMNET_H)
#endif
#ifdef HAVE_UNISTD_H
	b("HAVE_UNISTD_H", HAVE_UNISTD_H)
#endif
#ifdef HAVE_UTIME_H
	b("HAVE_UTIME_H", HAVE_UTIME_H)
#endif
#ifdef HOSTNAME
	s("HOSTNAME", HOSTNAME)
#endif
#ifdef __hpux
	b("__hpux", __hpux)
#endif
#ifdef HPUX
	b("HPUX", HPUX)
#endif
#ifdef IP_TOS
	b("IP_TOS", IP_TOS)
#endif
#ifdef ISC
	b("ISC", ISC)
#endif
#ifdef KEY_DOWN
	b("KEY_DOWN", KEY_DOWN)
#endif
#ifdef KEY_END
	b("KEY_END", KEY_END)
#endif
#ifdef KEY_ENTER
	b("KEY_ENTER", KEY_ENTER)
#endif
#ifdef KEY_LEFT
	b("KEY_LEFT", KEY_LEFT)
#endif
#ifdef KEY_RIGHT
	b("KEY_RIGHT", KEY_RIGHT)
#endif
#ifdef KEY_UP
	b("KEY_UP", KEY_UP)
#endif
#ifdef LIBMALLOC
	b("LIBMALLOC", LIBMALLOC)
#endif
#ifdef linux
	b("linux", linux)
#endif
#ifdef __linux__
	b("__linux__", __linux__)
#endif
#ifdef LOCK_METHOD
	i("LOCK_METHOD", LOCK_METHOD)
#endif
#ifdef LOG_LOCAL3
	i("LOG_LOCAL3", LOG_LOCAL3)
#endif
#ifdef LS
	s("LS", LS)
#endif
#ifdef MAXPATHLEN
	i("MAXPATHLEN", MAXPATHLEN)
#endif
#ifdef MORE
	s("MORE", MORE)
#endif
#ifdef MYPOPEN
	b("MYPOPEN", MYPOPEN)
#endif
#ifdef NCURSES_VERSION
	s("NCURSES_VERSION", NCURSES_VERSION)
#endif
#ifdef NO_FGTEST
	b("NO_FGTEST", NO_FGTEST)
#endif
#ifdef NeXT
	b("NeXT", NeXT)
#endif
#ifdef __osf__
	b("__osf__", __osf__)
#endif
#ifdef POLL_LOG
	b("POLL_LOG", POLL_LOG)
#endif
#ifdef _POSIX_VERSION
	i("_POSIX_VERSION", _POSIX_VERSION)
#endif
#ifdef POSIX_SIGNALS
	b("POSIX_SIGNALS", POSIX_SIGNALS)
#endif
#ifdef pyr
	b("pyr", pyr)
#endif
#ifdef SCO322
	b("SCO322", SCO322)
#endif
#ifdef SCO324
	b("SCO324", SCO324)
#endif
#ifdef SETVBUF_REVERSED
	b("SETVBUF_REVERSED", SETVBUF_REVERSED)
#endif
#ifdef __sgi
	b("__sgi", __sgi)
#endif
#ifdef SIGTSTP
	b("SIGTSTP", SIGTSTP)
#endif
#ifdef SINIX
	b("SINIX", SINIX)
#endif
#ifdef SO_LINGER
	b("SO_LINGER", SO_LINGER)
#endif
#ifdef SO_OOBINLINE
	b("SO_OOBINLINE", SO_OOBINLINE)
#endif
#ifdef __STDC__
	i("__STDC__", __STDC__)
#endif
#ifdef STDC_HEADERS
	b("STDC_HEADERS", STDC_HEADERS)
#endif
#ifdef __sun
	b("__sun", __sun)
#endif
#ifdef sun
	b("sun", sun)
#endif
#ifdef SVR4
	b("SVR4", SVR4)
#endif
#ifdef __svr4__
	b("__svr4__", __svr4__)
#endif
#ifdef SYSLOG
	b("SYSLOG", SYSLOG)
#endif
#ifdef _SYSTYPE_BSD
	b("_SYSTYPE_BSD", _SYSTYPE_BSD)
#endif
#ifdef _SYSTYPE_SYSV
	b("_SYSTYPE_SYSV", _SYSTYPE_SYSV)
#endif
#ifdef _SYSV
	b("_SYSV", _SYSV)
#endif
#ifdef SYSV
	b("SYSV", SYSV)
#endif
#ifdef ultrix
	b("ultrix", ultrix)
#endif
#ifdef UNAME
	s("UNAME", UNAME)
#endif
#ifdef USE_GETPWUID
	b("USE_GETPWUID", USE_GETPWUID)
#endif
#ifdef ZCAT
	s("ZCAT", ZCAT)
#endif
#ifdef __386BSD__
	b("__386BSD__", __386BSD__)
#endif
	{ NULL, 0, 0 }
};

int gNumCppSymbols = (int) (sizeof(gCppSymbols) / sizeof(CppSymbol)) - 1;

/* eof... */
