/* Cmdlist.c */

#include "Sys.h"

#include "Util.h"
#include "Main.h"
#include "Open.h"
#include "Cmds.h"
#include "Prefs.h"
#include "Cmdline.h"
#include "Complete.h"

/* The command list.  I suppose they don't really need to be in alphabetical
 * order, but some order is better than total chaos.
 */
Command gCommands[] = {
	{ "?",
		0,
		IgnoreCmd,
		kNoMin, kNoMax,
		"[optional commands]",
		"If the server is at a sub-prompt, send the command.  Otherwise ignore it.",
		kCompleteNone
	},
	{ ":",
		0,
		ShellCmd,
		kNoMin, kNoMax,
		"[command]",
		"Executes specified command, or if none given, runs a shell",
		kCompleteNone
	},
	{ "bye",
		kCmdHidden | kCmdWaitMsg,
		QuitCmd,
		0, 0,
		"",
		"exits Esh",
		kCompleteNone
	},
	{ "cd",
		0,
		LocalChdirCmd,
		kNoMin, 1,
		"<directory>",
		"changes local working directory",
		kCompleteLocal
	},
	{ "close",
		kCmdMustBeConnected | kCmdWaitMsg,
		CloseCmd,
		0, 0,
		"",
		"closes the connection to the remote host",
		kCompleteNone
	},
	{ "debug",
		0,
		DebugCmd,
		kNoMin, kNoMax,
		"[debug level]",
		"sets debug mode to level x",
		kCompleteNone
	},
	{ "echo",
		0,
		EchoCmd,
		kNoMin, kNoMax,
		"[items to echo]",
		"echos back to screen, expanding special % and @ sequences",
		kCompleteNone
	},
	{ "exit",
		kCmdHidden | kCmdWaitMsg,
		QuitCmd,
		0, 0,
		"",
		"quits Esh",
		kCompleteNone
	},
	{ "find",
		0,
		LookupCmd,
		1, kNoMax,
		"<host or IP number> [<more hosts or IP numbers>]",
		"looks up information in the host database",
		kCompleteNone
	},
	{ "game",
		0,
		GameCmd,
		0, 1,
		"[game name]",
		"Print the details for [game name].  If [gamer name] is not specified\n\
all games are listed.",
		kCompleteHost
	},
	{ "help",
		0,
		HelpCmd,
		kNoMin, kNoMax,
		"[optional commands]",
		"shows commands, or detailed help on specified commands",
		kCompleteCmd
	},
	{ "history",
		  0,
		  HistCmd,
		  kNoMin, 1,
		  "[number of commands]",
		  "shows the last [number of commands] (default 40) commands",
		  kCompleteNone
	},
	{ "macro",
		0,
		PrintMacro,
		0, 1,
		"[macro name]",
		"Print the definition of [macro name].  If no [macro name] is specified,\n\
all macro definitions are listed.",
		kCompleteMacro
	},
	{ "mail",
		0,
		MailCmd,
		0, 1,
		"[game name]",
		"Enter the mail shell to read telegrams received in [game name].  If\n\
is not specified, then telegrams for the current game are read.\n",
		kCompleteHost
	},
	{ "open",
		kCmdWaitMsg,
		OpenCmd,
		kNoMin, 4,
"[-flags] [hostname | nickname [port [country [password]]]]\n\
Flags:\n\
  -n   : Currently not used\n\
Examples:\n\
  open howit\n\
  open bowser.nintendo.co.jp 7777\n\
  open empire.net 7778 7 7\n",
		"connects to a remote host",
		kCompleteHost
	},
	{ "page",
		0,
		LocalPageCmd,
		1, kNoMax,
		"[-b | -p] localFiles...",
		"views a local file with your pager (-p) or built-in pager (-b)",
		kCompleteLocal
	},
	{ "pwd",
		0,
		LocalPwdCmd,
		0, 0,
		"",
		"Prints the current local working directory",
		kCompleteNone
	},
	{ "q",
		kCmdHidden | kCmdWaitMsg,
		QuitCmd,
		0, 0,
		"",
		"quits Esh",
		kCompleteNone
	},
	{ "quit",
		kCmdWaitMsg,
		QuitCmd,
		0, 0,
		"",
		"take a wild guess",
		kCompleteNone
	},
	{ "set",
		0,
		SetCmd,
		0, 2,
		"[option [newvalue]] | all | help",
		"lets you configure a program setting from the command line",
		kCompleteOption
	},
	{ "verbose",
		kCmdHidden,
		VerboseCmd,
		kNoMin, 1,
		"[verbosity level]",
		"sets verbosity mode to 0, 1, 2, or 3",
		kCompleteNone
	},
	{ "version",
		0,
		VersionCmd,
		kNoMin, kNoMax,
		"",
		"prints version information",
		kCompleteNone
	},
	{ "wmail",
		0,
		MailCmd,
		0, 1,
		"[game name]",
		"Enter the mail shell to read announcements for [game name].  If\n\
is not specified, then announcements for the current game are read.\n",
		kCompleteHost
	},
};

int gNumCommands = ((int) (sizeof(gCommands) / sizeof(Command)));
static Command gSendCommand =
{ "send",
	  kCmdMustBeConnected | kCmdWaitMsg,
	  SendCmd,
	  0, kNoMax,
	  "Empire-command",
	  "sends an Empire Command to the server",
	  kCompleteCmd,
  };

CMName gSendCM = {"", {&gSendCommand}, 1};

/* eof */
