#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/server/idle.c,v 2.2 1995/07/09 00:46:46 empire Exp $";
#endif

/*
 * idle.c
 *
 * Stamps out idle players.  Runs at low priority.
 *
 * Dave Pare, 1994
 */

#include "misc.h"
#include "player.h"
#include "io.h"
#include "lwp.h"
#include "proto.h"

/*ARGSUSED*/
void
player_kill_idle(argc, argv)
	int	argc;
	s_char	**argv;
{
	extern int max_idle;
	struct	player *p;
	long	now;

	time(&now);
	while (1) {
		lwpSleepUntil(now + 60);
		time(&now);
		/*if (update_pending)*/
			/*continue;*/
		for (p = player_next(0); p != 0; p = player_next(p)) {
			if (p->state == PS_SHUTDOWN) {
				/* no more mr. nice guy */
				p->state = PS_KILL;
				p->aborted++;
				lwpTerminate(p->proc);
				p = player_delete(p);
				continue;
			}
			if (p->curup + max_idle * 60 < now) {
				p->state = PS_SHUTDOWN;
				pr_flash(p, "idle connection terminated\n");
				p->aborted++;
				lwpWakeupFd(p->proc);
			}
		}
	}
	/*NOTREACHED*/
}
