#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/update/move_sat.c,v 2.5 1995/10/22 21:26:17 empire Exp $";
#endif

/*
 * move_sat.c
 *
 * Move a satellite to the next point in its orbit
 *
 */

#include <math.h>
#include "misc.h"
#include "var.h"
#include "plane.h"
#include "sect.h"
#include "xy.h"
#include "nsc.h"
#include "nat.h"
#include "path.h"
#include "deity.h"
#include "file.h"

#ifdef  ORBIT

#ifndef PI
#define	PI	3.14159265358979323846
#endif

void
move_sat(pp)
    register struct plnstr *pp;
{
    coord	x1,y1,x2,y2;
    coord	dx,dy;
    float	newtheta;
    struct sctstr	sect;

    newtheta = pp->pln_theta + .05;

    if (newtheta >= 1.0)
    {
	newtheta -= 1.0;
    };

    x1 = (coord)(2 * pp->pln_theta * WORLD_X);
    x1 = xnorm(x1);
    y1 = (coord)(sin(6 * PI * pp->pln_theta) * (WORLD_Y / 4));
    x2 = (coord)(2 * newtheta * WORLD_X);
    x2 = xnorm(x2);
    y2 = (coord)(sin(6 * PI * newtheta) * (WORLD_Y / 4));
    dx = x1 - pp->pln_x;
    dy = y1 - pp->pln_y;
    x2 -= dx;
    y2 -= dy;

    if	((x2 + y2) & 1)
    {
	x2++;
    };

    pp->pln_x = xnorm(x2);
    pp->pln_y = ynorm(y2);
    pp->pln_theta = newtheta;
    getsect(pp->pln_x, pp->pln_y, &sect);
    if (sect.sct_own)
	    if (pp->pln_own != sect.sct_own)
		    wu(0, sect.sct_own, "%s satellite spotted over %s\n",
		       cname(pp->pln_own), xyas(pp->pln_x, pp->pln_y, sect.sct_own));
    return;
}

#endif  /* ORBIT */
