/*
 * spool.c
 *
 * Ken Stevens, 1995
 * Spool messages to disk
 */

#include <stdio.h>
#include "misc.h"
#include "tel.h"
#include "nat.h"
#include "file.h"

spool_sync(cnum, s)
	natid	cnum;
	s_char	*s;
{
	FILE	*fp;
	s_char	filename[512];
	struct	natstr	*natp = getnatp(cnum);
	long	now;
	
	time(&now);
	if (natp->nat_synctim) {
		if (now - natp->nat_synctim > days(SYNC_KEEP_DAYS))
			return;
	} else {
		natp->nat_synctim = now;
		putnat(natp);
	}
		
	syncbox(filename, cnum);
	if (!(fp = fopen(filename, "a"))) {
		logerror("Write failed: %s", filename);
		return;
	}
	fputs(s, fp);
	fclose(fp);
}
