/*
 * askyn.c
 *
 * The oldest routines in the book...
 * ask questions of the user.
 *
 * ---ts, 1993
 */

#include "misc.h"
#include <fcntl.h>
#include <sys/uio.h>
#include "nat.h"
#include "tel.h"
#include "file.h"
#include "var.h"

/*
 * If they don't answer 'y' or 'Y', return 0
 */
int
confirm(promptstring)
	s_char	*promptstring;
{
	s_char	y_or_n[1024];
	char	c;

	if (getstring(promptstring, y_or_n) == 0)
		return 0;
	c = *y_or_n;
	if (c == 'y' || c == 'Y')
		return 1;
	return 0;
}

/*
 * Make them answer 'y', 'Y', 'n', or 'N', and
 * return 1 for y or Y, and 0 for n or N
 */
int
askyn(promptstring)
	s_char	*promptstring;
{
	s_char	y_or_n[1024];
	char	c;

	while (getstring(promptstring, y_or_n)) {
		c = *y_or_n;
		if (c == 'y' || c == 'Y')
			return 1;
		if (c == 'n' || c == 'N')
			return 0;
		pr("You must answer either yes or no!\n");
	}
	/* assume no if aborted */
	return 0;
}
