#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/strv.c,v 2.5 1995/10/18 03:25:39 empire Exp $";
#endif /* not lint */

/*
 * star.c
 *
 * do a starvation report
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "nsc.h"
#include "nat.h"
#include "deity.h"
#include "path.h"
#include "file.h"
#include <math.h>
#include "item.h"
#include "ship.h"
#include "optlist.h"
#include "land.h"

extern	int	etu_per_update;
static	void	starv_sects();
static	void	starv_ships();
static	void	starv_units();
static	void	sect_hdr();
static	void	ship_hdr();
static	void	unit_hdr();

starve()
{
	struct	nstr_sect nstr;
	int	do_sects = 0;
	int	do_ships = 0;
	int	do_units = 0;
	s_char	range[1024];

	if (opt_NOFOOD) {		/* no food - no work! */
		pr("No food is required in this game\n");
		return RET_OK;
	}

	strcpy(range, "*");
	if (!player->argp[1]) {
		do_sects = do_ships = do_units = 1;
	} else if (*(player->argp[1]) == 's') {
		do_ships = 1;
		if (player->argp[2])
			strcpy(range, player->argp[2]);
	} else if (*(player->argp[1]) == 'l') {
		do_units = 1;
		if (player->argp[2])
			strcpy(range, player->argp[2]);
	} else {
		if (!snxtsct(&nstr, player->argp[1]))
			return RET_SYN;
		do_sects = 1;
		strcpy(range, player->argp[1]);
	}
	prdate();
	if (do_sects)
		starv_sects(range);
	if (do_ships)
		starv_ships(range);
	if (do_units)
		starv_units(range);
	return RET_OK;
}

static void
starv_sects(range)
	s_char *range;
{
	struct	nstr_sect nstr;
	struct	sctstr sect;
	int	nsect = 0;
	int	vec[I_MAX+1], s, needed;

	if (!snxtsct(&nstr, range))
		return;
	while (nxtsct(&nstr, &sect)) {
		if (!player->owner)
			continue;
		if (sect.sct_type == SCT_SANCT)
			continue;

		getvec(VT_ITEM, vec, (s_char *)&sect, EF_SECTOR);
		s = feed_people(vec, etu_per_update, &needed);

		if (s==0)
			continue;
		if (nsect++ == 0)
			sect_hdr();
		if (player->god)
			pr("%3d ", sect.sct_own);
		prxy("%4d,%-4d", nstr.x, nstr.y, player->cnum);
		pr(" %c", dchr[sect.sct_type].d_mnem);
		pr(" %c", (sect.sct_own != sect.sct_oldown ? '*' : ' '));
		if (sect.sct_newtype != sect.sct_type)
			pr("%c", dchr[sect.sct_newtype].d_mnem);
		else
			pr(" ");
		pr("%4d%%", sect.sct_effic);
		pr(" will starve %d people. %d more food needed\n",s,
			needed);
	}
	if (nsect == 0) {
		if (player->argp[1])
			pr("%s: No sector(s)\n", player->argp[1]);
		else
			pr("%s: No sector(s)\n", "");
		return;
	}else
		pr("%d sector%s\n", nsect, splur(nsect));
	return;
}

static void
sect_hdr()
{
	if (player->god)
		pr("    ");
	pr("Starvation               \n");
	if (player->god)
		pr("own ");
	pr("  sect         eff ");
	pr("\n");
}

static void
starv_ships(range)
	s_char *range;
{
	struct	nstr_item ni;
	struct	shpstr ship;
	int	nship = 0;
	int	vec[I_MAX+1], s, needed;

	if (!snxtitem(&ni, EF_SHIP, range))
		return;

	while (nxtitem(&ni, (s_char *)&ship)) {
		if (!player->owner || !ship.shp_own)
			continue;

		getvec(VT_ITEM, vec, (s_char *)&ship, EF_SHIP);
		s = feed_ship(&ship, vec, etu_per_update, &needed);

		if (s==0)
			continue;
		if (nship++ == 0)
			ship_hdr();
		if (player->god)
			pr("%3d ", ship.shp_own);
		pr("%5d ", ship.shp_uid);
		pr("%-16.16s ", mchr[ship.shp_type].m_name);
		pr(" will starve %d people. %d more food needed\n",s,
			needed);
	}
	if (nship == 0) {
		if (range)
			pr("%s: No ship(s)\n", range);
		else
			pr("%s: No ship(s)\n", "");
		return;
	}else
		pr("%d ship%s\n", nship, splur(nship));
	return;
}

static void
ship_hdr()
{
	if (player->god)
		pr("    ");
	pr("Starvation               \n");
	if (player->god)
		pr("own ");
	pr(" shp#     ship type       \n");
}

static void
starv_units(range)
	s_char *range;
{
	struct	nstr_item ni;
	struct	lndstr land;
	int	nunit = 0;
	int	vec[I_MAX+1], s, needed;

	if (!snxtitem(&ni, EF_LAND, range))
		return;

	while (nxtitem(&ni, (s_char *)&land)) {
		if (!player->owner || !land.lnd_own)
			continue;

		getvec(VT_ITEM, vec, (s_char *)&land, EF_LAND);
		s = feed_land(&land, vec, etu_per_update, &needed);

		if (s==0)
			continue;
		if (nunit++ == 0)
			unit_hdr();
		if (player->god)
			pr("%3d ", land.lnd_own);
		pr("%5d ", land.lnd_uid);
		pr("%-16.16s ", lchr[land.lnd_type].l_name);
		pr(" will starve %d mil. %d more food needed\n",s,
			needed);
	}
	if (nunit == 0) {
		if (range)
			pr("%s: No unit(s)\n", range);
		else
			pr("%s: No unit(s)\n", "");
		return;
	}else
		pr("%d unit%s\n", nunit, splur(nunit));
	return;
}

static void
unit_hdr()
{
	if (player->god)
		pr("    ");
	pr("Starvation               \n");
	if (player->god)
		pr("own ");
	pr(" lnd#     unit type       \n");
}

/*
 * returns the number who starved, if any.
 */
int
feed_people(vec, etus, needed)
	register int *vec;
	int	etus;
	int	*needed;
{
	extern	double eatrate;
	double	food_eaten;
	double	people_left;
	int	can_eat;
	int	total_people;
	int	to_starve;
	int	starved;

	if (opt_NOFOOD)
		return 0;
	food_eaten = (etus * eatrate) *
		(vec[I_CIVIL] + vec[I_MILIT] + vec[I_UW]);
	if (food_eaten <= 1)
		return 0;
	starved = 0;
	*needed = 0;
	if (food_eaten > vec[I_FOOD]) {
		*needed = food_eaten - vec[I_FOOD];
		if (*needed < (food_eaten - vec[I_FOOD]))
			(*needed)++;
		if (opt_NEW_STARVE) {
			can_eat = (vec[I_FOOD] / (etus * eatrate));
			total_people = vec[I_CIVIL] + vec[I_MILIT] + vec[I_UW];

			/* only want to starve off at most 1/2 the populace. */
			if (can_eat < (total_people/2))
				can_eat = total_people/2;

			to_starve = total_people - can_eat;	
			while(to_starve && vec[I_UW]){
				to_starve--;
				starved++;
				vec[I_UW]--;
			}
			while(to_starve && vec[I_CIVIL]){
				to_starve--;
				starved++;
				vec[I_CIVIL]--;
			}
			while(to_starve && vec[I_MILIT]){
				to_starve--;
				starved++;
				vec[I_MILIT]--;
			}
		
			vec[I_FOOD] = 0;
		}
		else {		/* ! opt_NEW_STARVE */

			people_left = (vec[I_FOOD] + 0.01) / (food_eaten + 0.01);
			starved = vec[I_CIVIL] + vec[I_MILIT] + vec[I_UW];
			/* only want to starve off at most 1/2 the populace. */
			if (people_left < 0.5)
				people_left = 0.5;
			vec[I_CIVIL] = (int) (vec[I_CIVIL] * people_left);
			vec[I_MILIT] = (int) (vec[I_MILIT] * people_left);
			vec[I_UW] = (int) (vec[I_UW] * people_left);
			starved -= vec[I_CIVIL] + vec[I_MILIT] + vec[I_UW];
			vec[I_FOOD] = 0;
		} /* end opt_NEW_STARVE */
	} else {
		vec[I_FOOD] -= roundavg(food_eaten);
	}
	return starved;
}
