#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/star.c,v 2.0 1995/01/25 19:23:25 empire Exp $";
#endif /* not lint */

/*
 * star.c
 *
 * start a sector producing
 *
 * --ts 1992
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "nsc.h"
#include "nat.h"
#include "deity.h"
#include "path.h"
#include "file.h"
#include "product.h"

static start_hdr();

start()
{
	struct	sctstr sect;
	int	nsect;
	struct	nstr_sect nstr;

	if (!snxtsct(&nstr, player->argp[1]))
		return RET_SYN;
	prdate();
	nsect = 0;
	while (nxtsct(&nstr, &sect)) {
		if (!player->owner)
			continue;
		if (nsect++ == 0)
			start_hdr();
		if (player->god)
			pr("%3d ", sect.sct_own);
		prxy("%4d,%-4d", nstr.x, nstr.y, player->cnum);
		pr(" %c", dchr[sect.sct_type].d_mnem);
		if (sect.sct_newtype != sect.sct_type)
			pr("%c", dchr[sect.sct_newtype].d_mnem);
		else
			pr(" ");
		pr("%4d%%", sect.sct_effic);

		pr(" will be updated normally.\n");
		sect.sct_off = 0;
		putsect(&sect);
	}
	if (nsect == 0) {
		if (player->argp[1])
			pr("%s: No sector(s)\n", player->argp[1]);
		else
			pr("%s: No sector(s)\n", "");
		return RET_FAIL;
	}else
		pr("%d sector%s\n", nsect, splur(nsect));
	return 0;
}

static
start_hdr()
{
	if (player->god)
		pr("    ");
	pr("PRODUCTION STARTING\n");
	if (player->god)
		pr("own ");
	pr("  sect        eff\n");
}
