#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/real.c,v 2.2 1995/08/21 21:19:15 empire Exp $";
#endif

/*
 * real.c
 *
 * show or set realm
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "player.h"
#include "nat.h"
#include "xy.h"
#include "file.h"
#include "nsc.h"

real()
{
	register struct boundstr *rp;
	struct	natstr *natp;
	int     curr;
	int     lastr;
	struct	range abs;
	struct	range rel;
	struct	boundstr *b;
	s_char	*realmp = player->argp[1];

	natp = getnatp(player->cnum);
	if (!realmp) {
		curr = 0;
		lastr = MAXNOR - 1;
	} else {
		if (*realmp == '#')
			++realmp;
		if (!isdigit(*realmp))
			return RET_SYN;
		curr = lastr = atoi(realmp);
		if (curr < 0 || curr >= MAXNOR) {
			pr("Realm number must be in the range 0:%d\n",
			       MAXNOR-1);
			return RET_SYN;
		}
	}
	abs.width = 0;
	abs.height = 0;
	if (player->argp[2] == 0) {
		while (curr <= lastr) {
			b = &natp->nat_b[curr];
			abs.lx = b->b_xl;
			abs.hx = b->b_xh;
			abs.ly = b->b_yl;
			abs.hy = b->b_yh;
			xyrelrange(natp, &abs, &rel);
			pr("Realm #%d is %d:%d,%d:%d\n", curr,
				rel.lx, rel.hx, rel.ly, rel.hy);
			curr++;
		}
	} else {
		if (sarg_type(player->argp[2]) != NS_AREA)
			return RET_SYN;
		if (!sarg_area(player->argp[2], &abs))
			return RET_SYN;
		rp = &natp->nat_b[curr];
		rp->b_xl = abs.lx;
		rp->b_xh = abs.hx - 1;
		rp->b_yl = abs.ly;
		rp->b_yh = abs.hy - 1;
		natp->nat_b[curr] = *rp;
		putnat(natp);
	}
	return RET_OK;
}
/*
dreal()
{
	struct	natstr *natp;
	int     curr;
	int     lastr;
	struct	range abs;
	struct	range rel;
	struct	boundstr *b;
	int	nat;
	s_char	*rp = player->argp[1];

	lastr = MAXNOR - 1;
	curr  = 0;
	if (rp == 0) {
		nat = player->cnum;
	} else {
		nat = atoi(rp);
		if (nat < 0)
			return RET_SYN;
		if (nat >= MAXNOC)
			return RET_SYN;
	}
	pr("Realms for %s (#%d)\n",cname(nat),nat);
	natp = getnatp(nat);
	abs.width = 0;		
	abs.height = 0;
	while (curr <= lastr) {
		b = &natp->nat_b[curr];
		abs.lx = b->b_xl;
		abs.hx = b->b_xh;
		abs.ly = b->b_yl;
		abs.hy = b->b_yh;
		xyrelrange(natp, &abs, &rel);
		pr("Realm #%d is %d:%d,%d:%d\n", curr,
			rel.lx, rel.hx, rel.ly, rel.hy);
		curr++;
	}
	return RET_OK;
}
*/
