#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/play.c,v 2.10 1995/10/22 21:19:29 empire Exp $";
#endif /* not lint */

/*
 * play.c
 *
 * Who's logged on?
 *
 * Ken Stevens, 1995
 */

#include "misc.h"
#include "player.h"
#include "file.h"
#include "nat.h"
#include "optlist.h"

static void play_header();
static int  play_list();

int
play()
{
	struct	player *joe;
	int	saw = 0;
	int	count = 0;

	for (joe = player_prev(0); joe; joe = player_prev(joe)) {
		if (!count++)
			play_header();
		saw += play_list(joe);
	}
	if (player->god || opt_BLITZ)
		pr("%d player%s\n", count, splur(count));
	else {
		count = max(saw,max(1,
				    count
				    - !!(random()%13)
				    + !!(random()%13)
				    - random()%2
				    + random()%2
				    - !(random()%5)
				    + !(random()%5)
				    - !(random()%9)
				    + !(random()%9)));
		pr("approximately %d player%s are logged on right now\n",
		   count, splur(count));
	}
	/*
	 * The reason that this random formula is such a mess, is that
	 * we want to avoid having a distribution that people could
	 * figure out just by typing "players" 100 times.
	 */

	return RET_OK;
}

static void
play_header()
{
	prdate();
	pr("%9s %3s %-32s %5s %5s %-20s\n",
	   "", 
	   "#",
	   "",
	   "time",
	   "idle",
	   "last command"
	   );
}

static int
play_list(joe)
	struct	player *joe;
{
	long	now;
	s_char *com;
	struct  natstr *natp;

	if (joe->cnum < 0 ||
	    joe->cnum >= MAXNOC ||
	    !(natp = getnatp(joe->cnum)))
		return 0;

	if (!player->god &&
	    !opt_BLITZ &&
	    !joe->god &&
	    joe->cnum != player->cnum &&
	    getrel(natp, player->cnum) < ALLIED)
		return 0;
	time(&now);
	if (player->god)
		if (!joe->combuf || !*joe->combuf)
			com = "NULL";
		else
			com = joe->combuf;
	else
		com = "";

	pr("%-9.9s %3d %32.32s %2d:%02d %4ds %-20.20s\n",
	   cname(joe->cnum), 
	   joe->cnum,
         (player->god || joe->cnum == player->cnum)?praddr(joe):(s_char *)"",
	   natp->nat_minused / 60, natp->nat_minused % 60,
	   now - joe->curup,
	   com
	   );
	return 1;
}

