#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/newe.c,v 2.3 1995/08/16 05:50:05 empire Exp $";
#endif

/*
 * newe.c
 *
 * Show new efficiency (projected)
 *
 * --ts 1993
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "xy.h"
#include "nsc.h"
#include "sect.h"
#include "product.h"
#include "nat.h"
#include "item.h"
#include "file.h"

int
newe()
{
	extern	double obrate, uwbrate; 
	extern	int etu_per_update;
	struct	natstr *natp;
	struct	sctstr sect;
	struct	nstr_sect nstr;
	double  work, wforce, lcms, hcms;
	int     items[I_MAX+1];
	int     nsect;
	int	civs=0;
	int	uws=0;
	int	bwork;
	int	twork;
	int	type;
	int	eff;
	int	maxpop;

	if (!snxtsct(&nstr, player->argp[1]))
		return RET_SYN;
	prdate();
	nsect = 0;
	while (nxtsct(&nstr, &sect)) {
		if (!player->owner)
			continue;
                if (sect.sct_off)
			continue;

                getvec(VT_ITEM, items, (s_char *)&sect, EF_SECTOR);

                civs = min(999, (int) ((obrate * (double) etu_per_update + 1.0)
                       * (double) items[I_CIVIL]));
                uws = min(999, (int) ((uwbrate * (double) etu_per_update + 1.0)
                       * (double) items[I_UW]));
		natp = getnatp(sect.sct_own);
		maxpop = max_pop((float)natp->nat_level[NAT_RLEV], &sect);
		civs = min(civs, maxpop);
		uws = min(uws, maxpop);
		/* This isn't quite right, since research might rise/fall */
		/* during the update, but it's the best we can really do  */
		wforce = (int)
			((civs * sect.sct_work) / 100.0
			+ uws + items[I_MILIT] * 2 / 5.0);

		work = etu_per_update * wforce / 100.0;
		bwork = work/2;

		type = sect.sct_type;
		eff = sect.sct_effic;
		if(sect.sct_newtype != type) {
			twork = (eff+3)/4;
			if(twork > bwork) {
				twork = bwork;
			}
			work -= twork;
			bwork -= twork;
			eff -= twork*4;
			if(eff <= 0) {
				type = sect.sct_newtype;
				eff = 0;
			}

			twork = 100 - eff;
			if(twork > bwork) {
				twork = bwork;
			}
			if (dchr[type].d_lcms>0){
                        	lcms = items[I_LCM];
                        	lcms = (int)(lcms/dchr[type].d_lcms);
                        	if (twork > lcms)
                                	twork = lcms;
			}
			if (dchr[type].d_hcms>0){
                        	hcms = items[I_HCM];
                        	hcms = (int)(hcms/dchr[type].d_hcms);
                        	if (twork > hcms)
                                	twork = hcms;
                	}
			work -= twork;
			eff += twork;
		}
		else if(eff < 100) {
			twork = 100 - eff;
			if(twork > bwork) {
				twork = bwork;
			}
			if (dchr[type].d_lcms>0){
                        	lcms = items[I_LCM];
                        	lcms = (int)(lcms/dchr[type].d_lcms);
                        	if (twork > lcms)
                                	twork = lcms;
			}
			if (dchr[type].d_hcms>0){
                        	hcms = items[I_HCM];
                        	hcms = (int)(hcms/dchr[type].d_hcms);
                        	if (twork > hcms)
                                	twork = hcms;
                	}
			work -= twork;
			eff += twork;
		}

		if (nsect++ == 0) {
			pr("EFFICIENCY SIMULATION\n");
			pr("   sect  des    projected eff\n");
		}
		prxy("%4d,%-4d", nstr.x, nstr.y, player->cnum);
		pr(" %c", dchr[type].d_mnem);
		pr("    %3d%%\n", eff);
	}
	if (nsect == 0) {
		if (player->argp[1])
			pr("%s: No sector(s)\n", player->argp[1]);
		else
			pr("%s: No sector(s)\n", "");
		return RET_FAIL;
	}else
		pr("%d sector%s\n", nsect, splur(nsect));
	return RET_OK;
}

