#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/coun.c,v 2.1 1995/09/26 03:35:02 empire Exp $";
#endif /* not lint */

/*
 * coun.c
 *
 * do a country roster.
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "sect.h"
#include "nat.h"
#include "xy.h"
#include "nsc.h"
#include "file.h"
#include "deity.h"
#include <fcntl.h>
#include <ctype.h>

static coun_header();
static coun_list();

int
coun()
{
	struct	nstr_item ni;
	struct	natstr nat;
	int	first;

	pr("The 'country' command is temporarily out of order.\n");
	pr("Please use the 'players' command instead.\n");
	if (!snxtitem(&ni, EF_NATION, player->argp[1]))
		return RET_SYN;
	first = 1;
	while (nxtitem(&ni, (s_char *)&nat)) {
		if ((nat.nat_stat & STAT_INUSE) == 0)
			continue;
		if (((nat.nat_stat & GOD) != GOD) && !player->god)
			continue;
		if (first) {
			coun_header();
			first = 0;
		}
		coun_list((natid)ni.cur, &nat);
	}
	return RET_OK;
}

static
coun_header()
{
	prdate();
	pr("  #   last access       time\tstatus\t\t country name\n");
}

static
coun_list(cn, natp)
	natid	cn;
	struct	natstr *natp;
{
	s_char	*status;
	struct	sctstr sect;

	if (natp->nat_connected)
		pr("%3d  %-16.16s   [%d]",cn," Now logged on",
			natp->nat_btu);
	else
		pr("%3d  %-16.16s   [%d]", cn, ctime(&natp->nat_last_login),
			natp->nat_btu);

	if (natp->nat_stat & STAT_GOD)
		status = "DEITY";
	else if (natp->nat_stat & STAT_NEW)
		status = "New";
	else if (natp->nat_stat & STAT_SANCT)
		status = "Sanctuary";
	else if (natp->nat_stat & STAT_NORM) {
		getsect(natp->nat_xcap, natp->nat_ycap, &sect);
		if (sect.sct_own != cn ||
		    (sect.sct_type != SCT_CAPIT &&
		    sect.sct_type != SCT_MOUNT))
			status = "In flux";
		else if (natp->nat_money < 0)
			status = "Broke";
		else
			status = "Active";
	} else {
		status = "Visitor";
	}
	pr("\t%-9.9s\t %s\n", status, natp->nat_cnam);
}
