/*
 * product.h
 *
 * things having to do with product characteristics
 *
 * from PSL Empire, 1985
 * $Revision: 2.0 $ $Date: 1995/07/27 05:29:42 $
 */

#ifndef _PRODUCT_H_
#define _PRODUCT_H_

struct	pchrstr {
	u_char	p_nv;		/* number of constituents */
	u_char	p_vtype[MAXCHRNV];/* constituent types */
	u_short	p_vamt[MAXCHRNV]; /* constituent amounts */
	int	p_type;		/* vtype if product is a variable */
	int	p_level;	/* index (NAT_?LEV) if product is not a var */
	int	p_cost;		/* dollars / product unit */
	int	p_nrndx;	/* index into sect of natural resource */
	int	p_nrdep;	/* depletion as a % of resource used */
	int	p_nlndx;	/* index (NAT_?LEV) affecting production */
	int	p_nlmin;	/* minimum lvl required */
	int	p_nllag;	/* lag, mul by (lvl-nlmin)/(lvl-nlmin+nllag) */
	int	p_effic;	/* process efficiency, mult by p_effic/100 */
	s_char	*p_name;	/* name of product */
	s_char	*p_sname;	/* short (7char or less) name of product */
};

#define	P_SHELL	1
#define	P_GUN	2
#define	P_PETROL	3
#define	P_IRON	4
#define	P_DUST	5
#define	P_BAR	6
#define	P_FOOD	7
#define	P_OIL	8
#define	P_LCM	9
#define	P_HCM	10
#define	P_TLEV	11
#define	P_RLEV	12
#define	P_ELEV	13
#define	P_HLEV	14
#define P_URAN	15
#define P_MDUST	16

extern	struct pchrstr pchr[];

extern	int prd_maxno;

#endif /* _PRODUCT_H_ */
