/*
 * ioqueue.h
 *
 * stores and frees data associated with a file descriptor.
 * uses writev to write, and read to read.
 *
 * $Revision: 2.1 $ $Date: 1995/10/11 03:08:57 $
 */

#define MAXIOV		16

struct ioqueue {
	struct qelem queue;	/* queue fwd/back */
	int bsize;		/* basic block size */
	int cc;			/* character count */
};

struct io {
	struct qelem queue;	/* list of ioqueue elements */
	int nbytes;		/* number of data bytes present */
	int offset;		/* offset into current entry */
	s_char *data;		/* pointer to start */
};

s_char	*ioq_gets();
