#include "entry.h"

const char *rules[]={
 "\"^\\\"\\([^#]*\\)\\\"$\" = \"{\\1}\"",
 "\"^\\\"\\([^#]*\\)\\\" #\" = \"{\\1} #\"",
 "\"# \\\"\\([^#]*\\)\\\"$\" = \"# {\\1}\"",
 "\"# \\\"\\([^#]*\\)\\\"$\" = \"# {\\1} #\"",
 "\"}[ \t]*#[ \t]*{\" = \" \"",
 "\"^\\([0-9]*\\)$\" = \"{\\1}\"",
 "pages \"\\([0-9]+\\)\\(-\\|---\\)\\([0-9]+\\)\" = \"\\1--\\3\"",
 "\"\"=\"{\\`A}\"",              //iso2tex rules needed for
 "\"\"=\"{\\\\'A}\"",		    //automatic key generation
 "\"\"=\"{\\\\^A}\"",
 "\"\"=\"{\\\\~A}\"",
 "\"\"=\"{\\\\\\\"A}\"",
 "\"\"=\"{\\\\AA}\"",
 "\"\"=\"{\\\\AE}\"",
 "\"\"=\"{\\\\c{C}}\"",
 "\"\"=\"{\\\\`E}\"",
 "\"\"=\"{\\\\'E}\"",
 "\"\"=\"{\\\\^E}\"",
 "\"\"=\"{\\\\\\\"E}\"",
 "\"\"=\"{\\\\`I}\"",
 "\"\"=\"{\\\\'I}\"",
 "\"\"=\"{\\\\^I}\"",
 "\"\"=\"{\\\\\\\"I}\"",
 "\"\"=\"{\\\\~N}\"",
 "\"\"=\"{\\\\`O}\"",
 "\"\"=\"{\\\\'O}\"",
 "\"\"=\"{\\\\^O}\"",
 "\"\"=\"{\\\\~O}\"",
 "\"\"=\"{\\\\\\\"O}\"",
 "\"\"=\"{\\\\O}\"",
 "\"\"=\"{\\\\`U}\"",
 "\"\"=\"{\\\\'U}\"",
 "\"\"=\"{\\\\^U}\"",
 "\"\"=\"{\\\\\\\"U}\"",
 "\"\"=\"{\\\\'Y}\"",
 "\"\"=\"{\\\\ss}\"",
 "\"\"=\"{\\\\`a}\"",
 "\"\"=\"{\\\\'a}\"",
 "\"\"=\"{\\\\^a}\"",
 "\"\"=\"{\\\\~a}\"",
 "\"\"=\"{\\\\\\\"a}\"",
 "\"\"=\"{\\\\aa}\"",
 "\"\"=\"{\\\\ae}\"",
 "\"\"=\"{\\\\c{c}}\"",
 "\"\"=\"{\\\\`e}\"",
 "\"\"=\"{\\\\'e}\"",
 "\"\"=\"{\\\\^e}\"",
 "\"\"=\"{\\\\\\\"e}\"",
 "\"\"=\"{\\\\`{\\\\i}}\"",
 "\"\"=\"{\\\\'{\\\\i}}\"",
 "\"\"=\"{\\\\^{\\\\i}}\"",
 "\"\"=\"{\\\\\\\"{\\\\i}}\"",
 "\"\"=\"{\\\\~n}\"",
 "\"\"=\"{\\\\`o}\"",
 "\"\"=\"{\\\\'o}\"",
 "\"\"=\"{\\\\^o}\"",
 "\"\"=\"{\\\\~o}\"",
 "\"\"=\"{\\\\\\\"o}\"",
 "\"\"=\"{\\\\o}\"",
 "\"\"=\"{\\\\`u}\"",
 "\"\"=\"{\\\\'u}\"",
 "\"\"=\"{\\\\^u}\"",
 "\"\"=\"{\\\\\\\"u}\"",
 "\"\"=\"{\\\\'y}\"",
 "\"\"=\"{\\\\\\\"y}\"",
 NULL
};



void add_rewrite_rules(){
 const char **r=rules;
 while (*r) {
  char *p=qstrdup(*r);
  add_rewrite_rule(p);
  delete (p);
  r++;
 }
}
