/*
 *	This file contains definitions for the IMAGEN laser
 *	printer (imPRESS language).
 */

#define SP                  128
#define SP1                 129
#define MPLUS               131
#define MMINUS              132
#define MMOVE               133
#define SMOVE               134
#define SET_ABS_H           135
#define SET_REL_H           136
#define SET_ABS_V           137
#define SET_REL_V           138
#define CIRC_ARC            150
#define ELLIPSE_ARC         151
#define CIRC_SEGM           160
#define BRULE               193
#define CRLF                197
#define BGLY                199
#define DELG                200
#define SET_HV_SYSTEM       205
#define SET_ADV_DIRS        206
#define SET_FAMILY          207
#define SET_IL              208
#define SET_BOL             209
#define SET_SP              210
#define PUSH                211
#define POP                 212
#define PAGE                213
#define SET_PUSH_MASK       214
#define ENDPAGE             219
#define CREATE_FAMILY_TABLE 221
#define CREATE_MAP          222
#define SET_PUM             225
#define CREATE_PATH         230
#define SET_TEXTURE         231
#define SET_PEN             232
#define FILL_PATH           233
#define DRAW_PATH           234
#define BITMAP              235
#define SET_MAGNIFICATION   236
#define FORCE_GLY_DELETE    240
#define DEFINE_MACRO        242
#define EXECUTE_MACRO       243
#define NO_OP               254
#define EOF                 255

/*
 *	Rotations:
 */

#define ROTATE_0     0
#define ROTATE_90    1
#define ROTATE_180   2
#define ROTATE_270   3


/*
 *	SET_HV_SYSTEM further definitions:
 */

#define ORIGIN_NO_CHANGE 0
#define ORIGIN_TOP_LEFT  2
#define ORIGIN_PHYSICAL  3
#define AXES_NO_CHANGE   0
#define AXES_INVERT      1
#define AXES_POSITIVE    2
#define AXES_NEGATIVE    3
#define ORIENT_LOG_0     ROTATE_0
#define ORIENT_LOG_90    ROTATE_90
#define ORIENT_LOG_180   ROTATE_180
#define ORIENT_LOG_270   ROTATE_270
#define ORIENT_PHY_0     (4+ROTATE_0)
#define ORIENT_PHY_90    (4+ROTATE_90)
#define ORIENT_PHY_180   (4+ROTATE_180)
#define ORIENT_PHY_270   (4+ROTATE_270)

/*
 *	Graphic operation codes:
 */

#define GOP_WHITE   0
#define GOP_OPAQUE  3
#define GOP_OR      7
#define GOP_BLACK  15

/*
 *	Glyph family/member used for texture definition:
 */

#define TEXTURE_FAM_MEM ((95 << 7) + 127)

/*
 *	Maximum pen size:
 */

#define MAX_PEN_SIZE 19
