/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import nu.validator.xml.TypedInputSource;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LocalCacheEntityResolver
implements EntityResolver {
    private Map<String, String> pathMap;
    private EntityResolver delegate;
    private boolean allowRnc = false;

    public LocalCacheEntityResolver(Map<String, String> pathMap, EntityResolver delegate) {
        this.pathMap = pathMap;
        this.delegate = delegate;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        File f;
        String path = this.pathMap.get(systemId);
        if (path != null && (f = new File(path)).exists()) {
            TypedInputSource is = new TypedInputSource();
            is.setByteStream(new FileInputStream(f));
            is.setSystemId(systemId);
            is.setPublicId(publicId);
            if (systemId.endsWith(".rnc")) {
                is.setType("application/relax-ng-compact-syntax");
                if (!this.allowRnc) {
                    throw new IOException("Not an XML resource: " + systemId);
                }
            } else if (systemId.endsWith(".dtd")) {
                is.setType("application/xml-dtd");
            } else if (systemId.endsWith(".ent")) {
                is.setType("application/xml-external-parsed-entity");
            } else {
                is.setType("application/xml");
            }
            return is;
        }
        return this.delegate.resolveEntity(publicId, systemId);
    }

    public boolean isAllowRnc() {
        return this.allowRnc;
    }

    public void setAllowRnc(boolean allowRnc) {
        this.allowRnc = allowRnc;
    }
}

