/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import org.hibernate.dialect.function.array.DdlTypeHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.query.sqm.produce.function.FunctionArgumentTypeResolver;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmFunction;
import org.hibernate.type.BasicPluralType;

public class ArrayAndElementArgumentTypeResolver
implements FunctionArgumentTypeResolver {
    public static final FunctionArgumentTypeResolver DEFAULT_INSTANCE = new ArrayAndElementArgumentTypeResolver(0, 1);
    private final int arrayIndex;
    private final int[] elementIndexes;

    public ArrayAndElementArgumentTypeResolver(int arrayIndex, int ... elementIndexes) {
        this.arrayIndex = arrayIndex;
        this.elementIndexes = elementIndexes;
    }

    @Override
    public MappingModelExpressible<?> resolveFunctionArgumentType(SqmFunction<?> function, int argumentIndex, SqmToSqlAstConverter converter) {
        MappingModelExpressible<?> expressible;
        SqmTypedNode<?> node;
        if (argumentIndex == this.arrayIndex) {
            for (int elementIndex : this.elementIndexes) {
                MappingModelExpressible<?> expressible2;
                SqmTypedNode<?> node2 = function.getArguments().get(elementIndex);
                if (!(node2 instanceof SqmExpression) || (expressible2 = converter.determineValueMapping((SqmExpression)node2)) == null) continue;
                return DdlTypeHelper.resolveArrayType((DomainType)((Object)expressible2.getSingleJdbcMapping()), converter.getCreationContext().getSessionFactory().getTypeConfiguration());
            }
        } else if (ArrayHelper.contains(this.elementIndexes, argumentIndex) && (node = function.getArguments().get(this.arrayIndex)) instanceof SqmExpression && (expressible = converter.determineValueMapping((SqmExpression)node)) != null && expressible.getSingleJdbcMapping() instanceof BasicPluralType) {
            return ((BasicPluralType)expressible.getSingleJdbcMapping()).getElementType();
        }
        return null;
    }
}

