/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.access;

import java.util.ArrayList;
import java.util.List;
import net.i2p.i2ptunnel.access.Threshold;

class AccessCounter {
    private final List<Long> accesses = new ArrayList<Long>();

    AccessCounter() {
    }

    void recordAccess(long now) {
        this.accesses.add(now);
    }

    boolean isBreached(Threshold threshold, long now) {
        if (threshold.getConnections() == 0) {
            return !this.accesses.isEmpty();
        }
        if (this.accesses.size() < threshold.getConnections()) {
            return false;
        }
        long ignoreOlder = now - (long)(threshold.getSeconds() * 1000);
        for (int i = 0; i <= this.accesses.size() - threshold.getConnections(); ++i) {
            long start = this.accesses.get(i);
            if (start < ignoreOlder) continue;
            long end = start + (long)(threshold.getSeconds() * 1000);
            if (this.accesses.get(i + threshold.getConnections() - 1) > end) continue;
            return true;
        }
        return false;
    }

    boolean purge(long olderThan) {
        while (!this.accesses.isEmpty() && this.accesses.get(0) < olderThan) {
            this.accesses.remove(0);
        }
        return this.accesses.isEmpty();
    }
}

