/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class BasePath<B extends BasePath<B>>
implements Comparable<B> {
    abstract ImmutableList<String> getSegments();

    @Nullable
    B getParent() {
        ImmutableList<String> parts = this.getSegments();
        if (parts.isEmpty()) {
            return null;
        }
        return this.createPathWithSegments((ImmutableList<String>)parts.subList(0, parts.size() - 1));
    }

    B append(String path) {
        return this.append(path, true);
    }

    B append(String path, boolean splitPath) {
        Preconditions.checkArgument((path != null && !path.isEmpty() ? 1 : 0) != 0, (Object)"'path' must be a non-empty String");
        ImmutableList.Builder components = ImmutableList.builder();
        components.addAll(this.getSegments());
        if (splitPath) {
            components.add((Object[])this.splitChildPath(path));
        } else {
            components.add((Object)path);
        }
        return this.createPathWithSegments((ImmutableList<String>)components.build());
    }

    B append(BasePath<B> path) {
        ImmutableList<String> segments1 = this.getSegments();
        ImmutableList<String> segments2 = path.getSegments();
        ImmutableList.Builder components = ImmutableList.builderWithExpectedSize((int)(segments1.size() + segments2.size()));
        components.addAll(segments1);
        components.addAll(segments2);
        return this.createPathWithSegments((ImmutableList<String>)components.build());
    }

    boolean isPrefixOf(BasePath<B> path) {
        ImmutableList<String> prefixSegments = this.getSegments();
        ImmutableList<String> childSegments = path.getSegments();
        int size = prefixSegments.size();
        if (size > childSegments.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (((String)prefixSegments.get(i)).equals(childSegments.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(@Nonnull B other) {
        ImmutableList<String> thisSegments = this.getSegments();
        ImmutableList<String> otherSegments = ((BasePath)other).getSegments();
        int length = Math.min(thisSegments.size(), otherSegments.size());
        for (int i = 0; i < length; ++i) {
            int cmp = ((String)thisSegments.get(i)).compareTo((String)otherSegments.get(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return Integer.compare(thisSegments.size(), otherSegments.size());
    }

    abstract String[] splitChildPath(String var1);

    abstract B createPathWithSegments(ImmutableList<String> var1);
}

