/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.helper.model;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.traccar.model.BaseModel;
import org.traccar.model.Device;
import org.traccar.model.Group;
import org.traccar.model.GroupedModel;
import org.traccar.model.User;
import org.traccar.storage.Storage;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

public final class DeviceUtil {
    private DeviceUtil() {
    }

    public static void resetStatus(Storage storage) throws StorageException {
        storage.updateObject(new Device(), new Request(new Columns.Include("status")));
    }

    public static Collection<Device> getAccessibleDevices(Storage storage, long userId, Collection<Long> deviceIds, Collection<Long> groupIds) throws StorageException {
        List<Device> devices = storage.getObjects(Device.class, new Request((Columns)new Columns.All(), new Condition.Permission(User.class, userId, Device.class)));
        Map<Long, Device> deviceById = devices.stream().collect(Collectors.toUnmodifiableMap(BaseModel::getId, x -> x));
        Map<Long, List<Device>> devicesByGroup = devices.stream().filter(x -> x.getGroupId() > 0L).collect(Collectors.groupingBy(GroupedModel::getGroupId));
        List<Group> groups = storage.getObjects(Group.class, new Request((Columns)new Columns.All(), new Condition.Permission(User.class, userId, Group.class)));
        Map<Long, List<Group>> groupsByGroup = groups.stream().filter(x -> x.getGroupId() > 0L).collect(Collectors.groupingBy(GroupedModel::getGroupId));
        Set<Device> results = deviceIds.stream().map(deviceById::get).filter(Objects::nonNull).collect(Collectors.toSet());
        LinkedList<Long> groupQueue = new LinkedList<Long>(groupIds);
        while (!groupQueue.isEmpty()) {
            long groupId = groupQueue.pop();
            results.addAll(devicesByGroup.getOrDefault(groupId, Collections.emptyList()));
            groupQueue.addAll(groupsByGroup.getOrDefault(groupId, Collections.emptyList()).stream().map(BaseModel::getId).toList());
        }
        return results;
    }
}

