"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deflateValue = deflateValue;
exports.inflateValue = inflateValue;
var _nodeZlib = _interopRequireDefault(require("node:zlib"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 *   Copyright OpenSearch Contributors
 *
 *   Licensed under the Apache License, Version 2.0 (the "License").
 *   You may not use this file except in compliance with the License.
 *   A copy of the License is located at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   or in the "license" file accompanying this file. This file is distributed
 *   on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 *   express or implied. See the License for the specific language governing
 *   permissions and limitations under the License.
 */

function deflateValue(value, options = {}) {
  const compressedBuffer = _nodeZlib.default.deflateSync(value, options);
  return compressedBuffer;
}
function inflateValue(value, options = {}) {
  const uncompressedBuffer = _nodeZlib.default.inflateSync(value, options);
  return uncompressedBuffer;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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