"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.aggregateMetrics = aggregateMetrics;
exports.extractFieldsFromMappings = extractFieldsFromMappings;
exports.setSecurityAnalyticsPluginConfig = exports.getSecurityAnalyticsPluginConfig = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
var _constants = require("../server/utils/constants");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function aggregateMetrics(metrics, currentMetricsCounter) {
  const partialMetrics = {
    ...currentMetricsCounter
  };
  Object.keys(metrics).forEach(w => {
    const workflow = w;
    const workFlowMetrics = metrics[workflow];
    if (workFlowMetrics) {
      const counterToUpdate = partialMetrics[workflow] || _lodash.default.cloneDeep(_constants.DEFAULT_METRICS_COUNTER[workflow]);
      Object.entries(workFlowMetrics).forEach(([metric, count]) => {
        if (!counterToUpdate[metric]) {
          counterToUpdate[metric] = 0;
        }
        counterToUpdate[metric] += count;
      });
      partialMetrics[workflow] = counterToUpdate;
    }
  });
  return partialMetrics;
}
let securityAnalyticsPluginConfig;
const setSecurityAnalyticsPluginConfig = config => {
  securityAnalyticsPluginConfig = config;
};
exports.setSecurityAnalyticsPluginConfig = setSecurityAnalyticsPluginConfig;
const getSecurityAnalyticsPluginConfig = () => securityAnalyticsPluginConfig;
exports.getSecurityAnalyticsPluginConfig = getSecurityAnalyticsPluginConfig;
function extractFieldsFromMappings(properties, fields, parentField = '') {
  Object.keys(properties).forEach(field => {
    if (properties[field].hasOwnProperty('properties')) {
      extractFieldsFromMappings(properties[field]['properties'], fields, parentField ? `${parentField}.${field}` : field);
    } else {
      fields.push(parentField ? `${parentField}.${field}` : field);
    }
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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